/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PoolXADSCreateShutdownDBTest
extends BaseJDBCTestCase {
    static final String[] ADDITIONAL_DBS = new String[]{"dscreateconatdb1", "dscreateshutdowndb1", "dscreateshutdowndb2", "conflict1", "conflict2", "conflict3", "conflict4", "conflict5", "conflict6", "conflict7"};
    static String DBNotFoundState;
    private String ShutdownState = "08006";

    public PoolXADSCreateShutdownDBTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("PoolXADSCreateShutdownTest");
        Test test = TestConfiguration.defaultSuite(PoolXADSCreateShutdownDBTest.class);
        baseTestSuite.addTest(test);
        TestSetup testSetup = TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
        for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
            testSetup = TestConfiguration.additionalDatabaseDecorator((Test)testSetup, "emb" + ADDITIONAL_DBS[i]);
            testSetup = TestConfiguration.additionalDatabaseDecorator((Test)testSetup, "srv" + ADDITIONAL_DBS[i]);
        }
        return baseTestSuite;
    }

    @Override
    public void tearDown() throws Exception {
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
            PoolXADSCreateShutdownDBTest.removeDirectory(testConfiguration.getDatabasePath("emb" + ADDITIONAL_DBS[i]));
            PoolXADSCreateShutdownDBTest.removeDirectory(testConfiguration.getDatabasePath("srv" + ADDITIONAL_DBS[i]));
        }
        super.tearDown();
    }

    public void testPoolDS() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        this.doCreateAndShutdown(connectionPoolDataSource);
    }

    public void testXADS() throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        this.doCreateAndShutdown(xADataSource);
    }

    public void doCreateAndShutdown(Object object) throws SQLException {
        DBNotFoundState = PoolXADSCreateShutdownDBTest.usingEmbedded() ? "XJ004" : "08004";
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        PoolXADSCreateShutdownDBTest.assertUpdateCount(this.createStatement(), 0, "set schema APP");
        this.assertGetNull(object, string);
        this.assertSetAndGet(object, string, "shutdownDatabase", "shutdown");
        this.assertSetAndGet(object, string, "createDatabase", "create");
        this.assertNotSetAndGet(object, string, "shutdownDatabase", "boo");
        this.assertNotSetAndGet(object, string, "createDatabase", "boo");
        this.assertNotSetAndGet(object, string, "shutdownDatabase", "false");
        this.assertNotSetAndGet(object, string, "createDatabase", "false");
        this.assertReset(object, string);
        this.clearBeanProperties(object);
        this.assertCreateUsingConnAttrsOK(object, this.composeDatabaseName(ADDITIONAL_DBS[0]));
        this.clearBeanProperties(object);
        this.assertShutdownUsingConnAttrsOK(object, string);
        this.clearBeanProperties(object);
        string = this.composeDatabaseName(ADDITIONAL_DBS[1]);
        this.assertNoDB(object, string);
        this.clearBeanProperties(object);
        this.assertPositive(object, string);
        this.clearBeanProperties(object);
        string = this.composeDatabaseName(ADDITIONAL_DBS[2]);
        this.assertNoDB(object, string);
        this.clearBeanProperties(object);
        this.assertTwiceOK(object, string);
        this.clearBeanProperties(object);
        this.assertShutdownAndCreateConnAttr(DBNotFoundState, object, this.composeDatabaseName(ADDITIONAL_DBS[3]), "shutdown=true;create=true");
        this.clearBeanProperties(object);
        this.assertShutdownAndCreateConnAttr(DBNotFoundState, object, this.composeDatabaseName(ADDITIONAL_DBS[4]), "create=true;shutdown=true");
        this.clearBeanProperties(object);
        this.assertConflictedSettersOK(object, this.composeDatabaseName(ADDITIONAL_DBS[5]));
        this.clearBeanProperties(object);
        this.assertConflictedSetterConnAttrOK(object);
    }

    protected String composeDatabaseName(String string) {
        if (PoolXADSCreateShutdownDBTest.usingEmbedded()) {
            return "emb" + string;
        }
        return "srv" + string;
    }

    protected void assertGetNull(Object object, String string) throws SQLException {
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "shutdownDatabase"));
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "createDatabase"));
    }

    protected void assertSetAndGet(Object object, String string, String string2, String string3) throws SQLException {
        JDBCDataSource.setBeanProperty(object, string2, string3);
        PoolXADSCreateShutdownDBTest.assertEquals((String)string3, (String)PoolXADSCreateShutdownDBTest.getBeanProperty(object, string2).toString());
    }

    protected void assertNotSetAndGet(Object object, String string, String string2, String string3) throws SQLException {
        JDBCDataSource.setBeanProperty(object, string2, string3);
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, string2));
    }

    protected void assertReset(Object object, String string) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "createDatabase", "");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "createDatabase"));
        JDBCDataSource.setBeanProperty(object, "createDatabase", "create");
        PoolXADSCreateShutdownDBTest.assertEquals((Object)"create", (Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "createDatabase"));
        JDBCDataSource.setBeanProperty(object, "createDatabase", "boo");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "createDatabase"));
        JDBCDataSource.setBeanProperty(object, "createDatabase", "create");
        PoolXADSCreateShutdownDBTest.assertEquals((Object)"create", (Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "createDatabase"));
        JDBCDataSource.setBeanProperty(object, "createDatabase", "false");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "createDatabase"));
        JDBCDataSource.setBeanProperty(object, "createDatabase", "create");
        PoolXADSCreateShutdownDBTest.assertEquals((Object)"create", (Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "createDatabase"));
        JDBCDataSource.setBeanProperty(object, "createDatabase", "");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "createDatabase"));
        try {
            JDBCDataSource.setBeanProperty(object, "createDatabase", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JDBCDataSource.setBeanProperty(object, "shutdownDatabase", "");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(object, "shutdownDatabase", "shutdown");
        PoolXADSCreateShutdownDBTest.assertEquals((Object)"shutdown", (Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(object, "shutdownDatabase", "boo");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(object, "shutdownDatabase", "false");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(object, "shutdownDatabase", "shutdown");
        PoolXADSCreateShutdownDBTest.assertEquals((Object)"shutdown", (Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(object, "shutdownDatabase", "");
        PoolXADSCreateShutdownDBTest.assertNull((Object)PoolXADSCreateShutdownDBTest.getBeanProperty(object, "shutdownDatabase"));
        try {
            JDBCDataSource.setBeanProperty(object, "shutdownDatabase", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Object getBeanProperty(Object object, String string) {
        String string2 = PoolXADSCreateShutdownDBTest.getGetterName(string);
        Object object2 = null;
        try {
            Method method = object.getClass().getMethod(string2, null);
            object2 = method.invoke(object, null);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
        return object2;
    }

    private static String getGetterName(String string) {
        return "get" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    protected void assertShutdownUsingSetOK(Object object, String string, boolean bl) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(object, "databaseName", string);
        if (bl) {
            JDBCDataSource.setBeanProperty(object, "ConnectionAttributes", "shutdown=true");
        }
        this.assertDSConnectionFailed(this.ShutdownState, object);
    }

    protected void assertCreateUsingConnAttrsOK(Object object, String string) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "ConnectionAttributes", "create=true");
        JDBCDataSource.setBeanProperty(object, "databaseName", string);
        this.assertUpdateCount(object);
        JDBCDataSource.clearStringBeanProperty(object, "ConnectionAttributes");
        this.assertShutdownUsingSetOK(object, string, false);
    }

    protected void assertShutdownUsingConnAttrsOK(Object object, String string) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "databaseName", string);
        JDBCDataSource.setBeanProperty(object, "ConnectionAttributes", "shutdown=true");
        this.assertDSConnectionFailed(this.ShutdownState, object);
    }

    protected void assertShutdownAndCreateConnAttr(String string, Object object, String string2, String string3) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "databaseName", string2);
        JDBCDataSource.setBeanProperty(object, "ConnectionAttributes", string3);
        this.assertDSConnectionFailed(string, object);
    }

    protected void assertDSConnectionFailed(String string, Object object) throws SQLException {
        try {
            if (object instanceof ConnectionPoolDataSource) {
                ((ConnectionPoolDataSource)object).getPooledConnection();
            } else {
                ((XADataSource)object).getXAConnection();
            }
            PoolXADSCreateShutdownDBTest.fail((String)("expected an sqlexception " + string));
        }
        catch (SQLException sQLException) {
            PoolXADSCreateShutdownDBTest.assertSQLState(string, sQLException);
        }
    }

    protected void assertNoDB(Object object, String string) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "databaseName", string);
        this.assertDSConnectionFailed(DBNotFoundState, object);
    }

    protected void assertPositive(Object object, String string) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "databaseName", string);
        JDBCDataSource.setBeanProperty(object, "CreateDatabase", "create");
        this.assertUpdateCount(object);
        this.clearBeanProperties(object);
        this.assertShutdownUsingSetOK(object, string, false);
    }

    protected void assertTwiceOK(Object object, String string) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "databaseName", string);
        JDBCDataSource.setBeanProperty(object, "CreateDatabase", "create");
        JDBCDataSource.setBeanProperty(object, "ConnectionAttributes", "create=true");
        this.assertUpdateCount(object);
        this.clearBeanProperties(object);
        this.assertShutdownUsingSetOK(object, string, true);
    }

    protected void assertConflictedSettersOK(Object object, String string) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "databaseName", string);
        JDBCDataSource.setBeanProperty(object, "CreateDatabase", "create");
        JDBCDataSource.setBeanProperty(object, "shutdownDatabase", "shutdown");
        try {
            if (object instanceof ConnectionPoolDataSource) {
                ((ConnectionPoolDataSource)object).getPooledConnection();
            } else {
                ((XADataSource)object).getXAConnection();
            }
            PoolXADSCreateShutdownDBTest.fail((String)("expected an sqlexception " + DBNotFoundState));
        }
        catch (SQLException sQLException) {
            PoolXADSCreateShutdownDBTest.assertSQLState(DBNotFoundState, sQLException);
        }
    }

    protected void assertConflictedSetterConnAttrOK(Object object) throws SQLException {
        this.assertConSetOK(object, DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[6]), "shutdown=true", "CreateDatabase", "create");
        this.assertConSetOK(object, DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[7]), "create=true", "ShutdownDatabase", "shutdown");
        this.assertSetConOK(object, DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[8]), "shutdown=true", "CreateDatabase", "create");
        this.assertSetConOK(object, DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[9]), "create=true", "ShutdownDatabase", "shutdown");
    }

    protected void assertConSetOK(Object object, String string, String string2, String string3, String string4, String string5) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "databaseName", string2);
        JDBCDataSource.setBeanProperty(object, string4, string5);
        JDBCDataSource.setBeanProperty(object, "ConnectionAttributes", string3);
        try {
            if (object instanceof ConnectionPoolDataSource) {
                ((ConnectionPoolDataSource)object).getPooledConnection();
            } else {
                ((XADataSource)object).getXAConnection();
            }
            PoolXADSCreateShutdownDBTest.fail((String)("expected an sqlexception " + string));
        }
        catch (SQLException sQLException) {
            PoolXADSCreateShutdownDBTest.assertSQLState(string, sQLException);
        }
        JDBCDataSource.clearStringBeanProperty(object, string4);
        JDBCDataSource.clearStringBeanProperty(object, "ConnectionAttributes");
    }

    protected void assertSetConOK(Object object, String string, String string2, String string3, String string4, String string5) throws SQLException {
        JDBCDataSource.setBeanProperty(object, "databaseName", string2);
        JDBCDataSource.setBeanProperty(object, "ConnectionAttributes", string3);
        JDBCDataSource.setBeanProperty(object, string4, string5);
        try {
            if (object instanceof ConnectionPoolDataSource) {
                ((ConnectionPoolDataSource)object).getPooledConnection();
            } else {
                ((XADataSource)object).getXAConnection();
            }
            PoolXADSCreateShutdownDBTest.fail((String)("expected an sqlexception " + string));
        }
        catch (SQLException sQLException) {
            PoolXADSCreateShutdownDBTest.assertSQLState(string, sQLException);
        }
        JDBCDataSource.clearStringBeanProperty(object, "ConnectionAttributes");
        JDBCDataSource.clearStringBeanProperty(object, string4);
    }

    protected void assertUpdateCount(Object object) throws SQLException {
        if (object instanceof ConnectionPoolDataSource) {
            PoolXADSCreateShutdownDBTest.assertUpdateCount(((ConnectionPoolDataSource)object).getPooledConnection().getConnection().createStatement(), 0, "set schema APP");
        } else {
            PoolXADSCreateShutdownDBTest.assertUpdateCount(((XADataSource)object).getXAConnection().getConnection().createStatement(), 0, "set schema APP");
        }
    }

    private void clearBeanProperties(Object object) throws SQLException {
        JDBCDataSource.clearStringBeanProperty(object, "createDatabase");
        JDBCDataSource.clearStringBeanProperty(object, "shutdownDatabase");
        JDBCDataSource.clearStringBeanProperty(object, "connectionAttributes");
        JDBCDataSource.clearStringBeanProperty(object, "databaseName");
    }
}

