/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import junit.extensions.TestSetup;
import junit.framework.Test;

public class LocaleTestSetup
extends TestSetup {
    private Locale oldLocale = Locale.getDefault();
    private Locale newLocale;

    public LocaleTestSetup(Test test, Locale locale) {
        super(test);
        this.newLocale = locale;
    }

    protected void setUp() {
        LocaleTestSetup.setDefaultLocale(this.newLocale);
    }

    protected void tearDown() {
        LocaleTestSetup.setDefaultLocale(this.oldLocale);
    }

    public static void setDefaultLocale(final Locale locale) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Locale.setDefault(locale);
                return null;
            }
        });
    }
}

