/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.streams;

import java.io.UnsupportedEncodingException;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;

public class ByteAlphabet {
    private final String name;
    private final String encoding;
    private final byte[] bytes;
    private final int charCount;
    private final int byteCount;
    private int boff = 0;

    public static ByteAlphabet modernLatinLowercase() {
        return new ByteAlphabet("Modern latin lowercase, US-ASCII", CharAlphabet.MODERNLATINLOWER, "US-ASCII");
    }

    public static ByteAlphabet norwegianLowercase() {
        return new ByteAlphabet("Norwegian/Danish lowercase, ISO-8859-1", CharAlphabet.NO_DK_LOWER, "ISO-8859-1");
    }

    public static ByteAlphabet tamilUTF8() {
        return new ByteAlphabet("Tamil, UTF-8", CharAlphabet.TAMIL, "UTF8");
    }

    public static ByteAlphabet tamilUTF16BE() {
        return new ByteAlphabet("Tamil, UTF-16BE", CharAlphabet.TAMIL, "UTF-16BE");
    }

    public static ByteAlphabet cjkSubsetUTF8() {
        return new ByteAlphabet("CJK subset, UTF-8", CharAlphabet.CJKSUBSET, "UTF8");
    }

    public static ByteAlphabet cjkSubsetUTF16BE() {
        return new ByteAlphabet("CJK subset, UTF-16BE", CharAlphabet.CJKSUBSET, "UTF-16BE");
    }

    public static ByteAlphabet singleByte(byte by) {
        return new ByteAlphabet("Single byte: " + by, new char[]{(char)(by & 0xFF)}, "US-ASCII");
    }

    private ByteAlphabet(String string, char[] cArray, String string2) {
        byte[] byArray;
        this.name = string;
        this.encoding = string2;
        this.charCount = cArray.length;
        String string3 = new String(cArray);
        try {
            byArray = string3.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = new byte[]{0};
        }
        this.bytes = byArray;
        this.byteCount = byArray.length;
    }

    public String getName() {
        return this.name;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int charCount() {
        return this.charCount;
    }

    public int byteCount() {
        return this.byteCount;
    }

    public byte nextByte() {
        if (this.boff >= this.byteCount) {
            this.boff = 0;
        }
        return this.bytes[this.boff++];
    }

    public void reset() {
        this.boff = 0;
    }

    public int nextByteToRead(int n) {
        this.boff = (this.boff + n % this.byteCount) % this.byteCount;
        return this.boff;
    }
}

