/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class IndexSplitDeadlockTest
extends BaseJDBCTestCase {
    private List<AsyncThread> threads = new ArrayList<AsyncThread>();

    public IndexSplitDeadlockTest(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = TestConfiguration.embeddedSuite(IndexSplitDeadlockTest.class);
        object = DatabasePropertyTestSetup.singleProperty(object, "derby.locks.deadlockTrace", "true");
        object = new CleanDatabaseTestSetup((Test)object);
        return object;
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        for (AsyncThread asyncThread : this.threads) {
            asyncThread.waitFor();
        }
        this.threads = null;
        this.setAutoCommit(false);
        JDBC.dropSchema(this.getConnection().getMetaData(), "APP");
        super.tearDown();
    }

    public void testBTreeMaxScan_fetchMaxRowFromBeginning() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table max_scan(x int)");
        statement.executeUpdate("create index idx on max_scan(x)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into max_scan values ?");
        for (int i = 0; i < 500; ++i) {
            preparedStatement.setInt(1, i * 2);
            preparedStatement.executeUpdate();
        }
        this.commit();
        statement.executeUpdate("delete from max_scan where x > 50");
        this.obstruct("update max_scan set x = x where x = 10", 2000L);
        Thread.sleep(1000L);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select max(x) from max_scan --DERBY-PROPERTIES index=IDX"), "50");
    }

    public void testBTreeForwardScan_fetchRows_resumeAfterSplit() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (x int)");
        statement.executeUpdate("create index idx on t(x)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 400; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        ResultSet resultSet = statement.executeQuery("select * from t --DERBY-PROPERTIES index=IDX");
        for (int i = 0; i < 30; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)resultSet.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)resultSet.getInt(1));
        }
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement();
        for (n = 0; n < 300; ++n) {
            statement2.executeUpdate("insert into t values -1");
        }
        statement2.close();
        connection.close();
        for (n = 30; n < 400; ++n) {
            IndexSplitDeadlockTest.assertTrue((boolean)resultSet.next());
            IndexSplitDeadlockTest.assertEquals((int)n, (int)resultSet.getInt(1));
        }
        IndexSplitDeadlockTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeScanAfterCommitAndSplit() throws SQLException {
        int n;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (x int)");
        statement.executeUpdate("create index idx on t(x)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 1000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        IndexSplitDeadlockTest.assertEquals((String)"This test must use a holdable cursor", (int)1, (int)statement.getResultSetHoldability());
        ResultSet resultSet = statement.executeQuery("select * from t --DERBY-PROPERTIES index=IDX");
        for (int i = 0; i < 500; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)resultSet.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)resultSet.getInt(1));
        }
        this.commit();
        Statement statement2 = this.createStatement();
        for (n = 0; n < 300; ++n) {
            statement2.executeUpdate("insert into t values 498");
        }
        for (n = 500; n < 1000; ++n) {
            IndexSplitDeadlockTest.assertTrue((boolean)resultSet.next());
            IndexSplitDeadlockTest.assertEquals((int)n, (int)resultSet.getInt(1));
        }
        IndexSplitDeadlockTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeScanAfterCompress() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (x int)");
        statement.executeUpdate("create index idx on t(x)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 1000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        IndexSplitDeadlockTest.assertEquals((String)"This test must use a holdable cursor", (int)1, (int)statement.getResultSetHoldability());
        ResultSet resultSet = statement.executeQuery("select * from t --DERBY-PROPERTIES index=IDX");
        for (int i = 0; i < 500; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)resultSet.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)resultSet.getInt(1));
        }
        this.commit();
        Statement statement2 = this.createStatement();
        statement2.executeUpdate("delete from t");
        this.commit();
        Thread.sleep(1000L);
        statement2.execute("call syscs_util.syscs_inplace_compress_table('APP','T',1,1,1)");
        this.commit();
        int n = 500;
        while (resultSet.next()) {
            IndexSplitDeadlockTest.assertTrue((n < 1000 ? 1 : 0) != 0);
            IndexSplitDeadlockTest.assertEquals((int)n, (int)resultSet.getInt(1));
            ++n;
        }
        resultSet.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeAfterWait_unique() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (x int, constraint c primary key(x))");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 300; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        this.obstruct("delete from t where x = 100", 2000L);
        Thread.sleep(1000L);
        ResultSet resultSet = statement.executeQuery("select * from t --DERBY-PROPERTIES constraint=C");
        for (int i = 0; i < 300; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)resultSet.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)resultSet.getInt(1));
        }
        IndexSplitDeadlockTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeAfterWait_unique_split() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (x int, constraint c primary key(x))");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 300; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        final Barrier barrier = new Barrier(2);
        new AsyncThread(new AsyncTask(){

            @Override
            public void doWork(Connection connection) throws Exception {
                connection.setAutoCommit(false);
                Statement statement = connection.createStatement();
                statement.executeUpdate("update t set x = x where x = 40");
                statement.close();
                barrier.await();
                Thread.sleep(1000L);
                PreparedStatement preparedStatement = connection.prepareStatement("insert into t values ?");
                for (int i = -1; i > -300; --i) {
                    preparedStatement.setInt(1, i);
                    preparedStatement.executeUpdate();
                }
                preparedStatement.close();
                connection.commit();
            }
        });
        ResultSet resultSet = statement.executeQuery("select * from t --DERBY-PROPERTIES constraint=C");
        for (int i = 0; i < 300; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)resultSet.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)resultSet.getInt(1));
            if (i != 0) continue;
            barrier.await();
        }
        IndexSplitDeadlockTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeAfterWait_nonUnique() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (x int)");
        statement.executeUpdate("create index idx on t(x)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 300; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        this.obstruct("delete from t where x = 100", 2000L);
        Thread.sleep(1000L);
        ResultSet resultSet = statement.executeQuery("select * from t --DERBY-PROPERTIES index=IDX");
        for (int i = 0; i < 300; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)resultSet.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)resultSet.getInt(1));
        }
        IndexSplitDeadlockTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeAfterWait_nonUnique_split() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (x int)");
        statement.executeUpdate("create index idx on t(x)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 300; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        final Barrier barrier = new Barrier(2);
        new AsyncThread(new AsyncTask(){

            @Override
            public void doWork(Connection connection) throws Exception {
                connection.setAutoCommit(false);
                Statement statement = connection.createStatement();
                statement.executeUpdate("update t set x = x where x = 40");
                barrier.await();
                Thread.sleep(1000L);
                for (int i = 0; i < 300; ++i) {
                    statement.executeUpdate("insert into t values -1");
                }
                statement.close();
                connection.commit();
            }
        });
        ResultSet resultSet = statement.executeQuery("select * from t --DERBY-PROPERTIES index=IDX");
        for (int i = 0; i < 300; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)resultSet.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)resultSet.getInt(1));
            if (i != 0) continue;
            barrier.await();
        }
        IndexSplitDeadlockTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
    }

    public void testMultipleLastKeyWaitsInMaxScan() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table max_scan(x int, y int)");
        statement.execute("create index idx on max_scan(x)");
        statement.execute("insert into max_scan(x) values 1,2,3");
        this.commit();
        new AsyncThread(new AsyncTask(){

            @Override
            public void doWork(Connection connection) throws Exception {
                int n;
                connection.setAutoCommit(false);
                Statement statement = connection.createStatement();
                statement.execute("update max_scan set y = x where x = 3");
                statement.close();
                Thread.sleep(2000L);
                PreparedStatement preparedStatement = connection.prepareStatement("insert into max_scan(x) values 4");
                for (n = 0; n < 300; ++n) {
                    preparedStatement.execute();
                }
                connection.commit();
                for (n = 0; n < 300; ++n) {
                    preparedStatement.execute();
                }
                Thread.sleep(500L);
                connection.commit();
                preparedStatement.close();
            }
        });
        int n = 0;
        do {
            Thread.sleep(500L);
        } while (this.numlocks() < 2 && (n += 500) < 60000);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select max(x) from max_scan --DERBY-PROPERTIES index=IDX"), "4");
    }

    private int numlocks() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT count(*) from syscs_diag.lock_table");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    public void testMultiplePrevKeyWaitsInForwardScan() throws Exception {
        this.setAutoCommit(false);
        this.getConnection().setTransactionIsolation(8);
        Statement statement = this.createStatement();
        statement.execute("create table fw_scan(x int)");
        statement.execute("create index idx on fw_scan(x)");
        statement.execute("insert into fw_scan(x) values 100,200,300");
        this.commit();
        new AsyncThread(new AsyncTask(){

            @Override
            public void doWork(Connection connection) throws Exception {
                int n;
                connection.setAutoCommit(false);
                PreparedStatement preparedStatement = connection.prepareStatement("insert into fw_scan values 1");
                preparedStatement.execute();
                Thread.sleep(2000L);
                for (n = 0; n < 300; ++n) {
                    preparedStatement.execute();
                }
                connection.commit();
                for (n = 0; n < 300; ++n) {
                    preparedStatement.execute();
                }
                Thread.sleep(500L);
                connection.rollback();
                preparedStatement.close();
            }
        });
        Thread.sleep(1000L);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select x from fw_scan --DERBY-PROPERTIES index=IDX\nwhere x >= 100 and x < 200"), "100");
    }

    private void obstruct(final String string, final long l) {
        AsyncTask asyncTask = new AsyncTask(){

            @Override
            public void doWork(Connection connection) throws Exception {
                connection.setAutoCommit(false);
                Statement statement = connection.createStatement();
                statement.execute(string);
                statement.close();
                Thread.sleep(l);
            }
        };
        new AsyncThread(asyncTask);
    }

    private class AsyncThread
    implements Runnable {
        private final Thread thread = new Thread(this);
        private final AsyncTask task;
        private Exception error;

        public AsyncThread(AsyncTask asyncTask) {
            this.task = asyncTask;
            this.thread.start();
            IndexSplitDeadlockTest.this.threads.add(this);
        }

        @Override
        public void run() {
            try {
                Connection connection = IndexSplitDeadlockTest.this.openDefaultConnection();
                try {
                    this.task.doWork(connection);
                }
                finally {
                    JDBC.cleanup(connection);
                }
            }
            catch (Exception exception) {
                this.error = exception;
            }
        }

        void waitFor() throws Exception {
            this.thread.join();
            if (this.error != null) {
                throw this.error;
            }
        }
    }

    private static interface AsyncTask {
        public void doWork(Connection var1) throws Exception;
    }
}

