/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import org.apache.derby.agg.Aggregator;

public class LobMode<V>
implements Aggregator<V, V, LobMode<V>> {
    private HashMap<String, Accumulator<V>> _accumulators;

    public void init() {
        this._accumulators = new HashMap();
    }

    public void accumulate(V v) {
        this.getAccumulator(v).add(1);
    }

    public void merge(LobMode<V> lobMode) {
        HashMap<String, Accumulator<V>> hashMap = lobMode._accumulators;
        for (Accumulator<V> accumulator : hashMap.values()) {
            V v = accumulator.getValue();
            this.getAccumulator(v).add(accumulator.getCount());
        }
    }

    public V terminate() {
        return this._accumulators.isEmpty() ? null : (V)Collections.max(this._accumulators.values()).getValue();
    }

    private Accumulator<V> getAccumulator(V v) {
        String string = LobMode.toString(v);
        Accumulator<V> accumulator = this._accumulators.get(string);
        if (accumulator == null) {
            accumulator = new Accumulator<V>(v);
            this._accumulators.put(string, accumulator);
        }
        return accumulator;
    }

    static String toString(Object object) {
        try {
            if (object instanceof Clob) {
                Clob clob = (Clob)object;
                return clob.getSubString(1L, (int)clob.length());
            }
            if (object instanceof Blob) {
                Blob blob = (Blob)object;
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                return new String(byArray, "UTF-8");
            }
            if (object instanceof Date) {
                return object.toString();
            }
            if (object instanceof Time) {
                return object.toString();
            }
            if (object instanceof Timestamp) {
                return object.toString();
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return new String(byArray, "UTF-8");
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
    }

    public static final class Accumulator<V>
    implements Comparable<Accumulator<V>> {
        private V _value;
        private int _count;

        public Accumulator(V v) {
            this._value = v;
            this._count = 0;
        }

        public void add(int n) {
            this._count += n;
        }

        public V getValue() {
            return this._value;
        }

        public int getCount() {
            return this._count;
        }

        @Override
        public int compareTo(Accumulator<V> accumulator) {
            int n = this._count - accumulator._count;
            if (n != 0) {
                return n;
            }
            return LobMode.toString(this._value).compareTo(LobMode.toString(accumulator._value));
        }
    }

    public static final class TimestampMode
    extends LobMode<Timestamp> {
    }

    public static final class TimeMode
    extends LobMode<Time> {
    }

    public static final class DateMode
    extends LobMode<Date> {
    }

    public static final class BinaryMode
    extends LobMode<byte[]> {
    }

    public static final class BlobMode
    extends LobMode<Blob> {
    }

    public static final class ClobMode
    extends LobMode<Clob> {
    }
}

