/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.Utf8CcsidManager;
import org.apache.derbyTesting.functionTests.util.TestNullOutputStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Utf8CcsidManagerClientTest
extends BaseTestCase {
    private static final String CANNOT_CONVERT = "22005";
    private Utf8CcsidManager ccsidManager = new Utf8CcsidManager();
    private Agent agent;

    public Utf8CcsidManagerClientTest(String string) throws Exception {
        super(string);
        PrintWriter printWriter = new PrintWriter(new TestNullOutputStream());
        this.agent = new NetAgent(null, new LogWriter(printWriter, 0));
    }

    protected void tearDown() {
        this.ccsidManager = null;
        this.agent = null;
    }

    public void testConvertFromJavaString() throws Exception {
        String string = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        byte[] byArray = new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        byte[] byArray2 = this.ccsidManager.convertFromJavaString(string, null);
        Utf8CcsidManagerClientTest.assertTrue((String)"UTF-8 conversion isn't equal to bytes", (boolean)Arrays.equals(byArray, byArray2));
    }

    public void testConvertFromJavaStringWithOffset() throws Exception {
        String string = new String(new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-16"), "UTF-16");
        byte[] byArray = new String("\u53f0\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        byte[] byArray2 = new byte[byArray.length];
        byArray2[0] = byArray[0];
        byArray2[1] = byArray[1];
        byArray2[2] = byArray[2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byteBuffer.position(3);
        this.ccsidManager.startEncoding();
        boolean bl = this.ccsidManager.encode(CharBuffer.wrap(string), byteBuffer, null);
        Utf8CcsidManagerClientTest.assertTrue((String)"Overflow in encode()", (boolean)bl);
        Utf8CcsidManagerClientTest.assertTrue((String)"UTF-8 conversion isn't equal to bytes (with buffer)", (boolean)Arrays.equals(byArray, byArray2));
    }

    public void testConvertToJavaString() throws Exception {
        byte[] byArray = new String("\u4f60\u597d\u4e16\u754c").getBytes("UTF-8");
        String string = new String(new String("\u597d\u4e16").getBytes("UTF-16"), "UTF-16");
        String string2 = this.ccsidManager.convertToJavaString(byArray, 3, 6);
        Utf8CcsidManagerClientTest.assertEquals((String)string, (String)string2);
    }

    public void testInvalidCharacters() {
        block5: {
            String string;
            block4: {
                string = "\ud800";
                this.ccsidManager.startEncoding();
                try {
                    this.ccsidManager.encode(CharBuffer.wrap(string), ByteBuffer.allocate(10), this.agent);
                    Utf8CcsidManagerClientTest.fail((String)"Encoding invalid codepoint should fail");
                }
                catch (SqlException sqlException) {
                    if (CANNOT_CONVERT.equals(sqlException.getSQLState())) break block4;
                    Utf8CcsidManagerClientTest.fail("Expected SQLState 22005", sqlException);
                }
            }
            try {
                this.ccsidManager.convertFromJavaString(string, this.agent);
                Utf8CcsidManagerClientTest.fail((String)"Encoding invalid codepoint should fail");
            }
            catch (SqlException sqlException) {
                if (CANNOT_CONVERT.equals(sqlException.getSQLState())) break block5;
                Utf8CcsidManagerClientTest.fail("Expected SQLState 22005", sqlException);
            }
        }
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(Utf8CcsidManagerClientTest.class);
    }
}

