/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.IOException;
import java.io.InputStream;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.query.InputStreamMarker;

public class EncodingDetector {
    public static String inferStreamEncoding(InputStream is, String defaultEncoding, Logger err) throws IOException {
        InputStreamMarker marker = new InputStreamMarker(is);
        marker.mark(100);
        byte[] start = new byte[100];
        int read = is.read(start, 0, 100);
        marker.reset();
        return EncodingDetector.inferEncoding(start, read, defaultEncoding, err);
    }

    private static String inferEncoding(byte[] start, int read, String defaultEncoding, Logger logger) {
        boolean debug;
        boolean bl = debug = logger != null;
        if (read >= 2) {
            if (EncodingDetector.ch(start[0]) == 254 && EncodingDetector.ch(start[1]) == 255) {
                if (debug) {
                    logger.info("unparsed-text(): found UTF-16 byte order mark");
                }
                return "UTF-16";
            }
            if (EncodingDetector.ch(start[0]) == 255 && EncodingDetector.ch(start[1]) == 254) {
                if (debug) {
                    logger.info("unparsed-text(): found UTF-16LE byte order mark");
                }
                return "UTF-16LE";
            }
        }
        if (read >= 3 && EncodingDetector.ch(start[0]) == 239 && EncodingDetector.ch(start[1]) == 187 && EncodingDetector.ch(start[2]) == 191) {
            if (debug) {
                logger.info("unparsed-text(): found UTF-8 byte order mark");
            }
            return "UTF-8";
        }
        if (read >= 4) {
            if (EncodingDetector.ch(start[0]) == 60 && EncodingDetector.ch(start[1]) == 63 && EncodingDetector.ch(start[2]) == 120 && EncodingDetector.ch(start[3]) == 109 && EncodingDetector.ch(start[4]) == 108) {
                if (debug) {
                    logger.info("unparsed-text(): found XML declaration");
                }
                StringBuilder sb = new StringBuilder(read);
                for (int b = 0; b < read; ++b) {
                    sb.append((char)start[b]);
                }
                String p = sb.toString();
                int v = p.indexOf("encoding");
                if (v >= 0) {
                    v += 8;
                    while (v < p.length() && " \n\r\t=\"'".indexOf(p.charAt(v)) >= 0) {
                        ++v;
                    }
                    sb.setLength(0);
                    while (v < p.length() && p.charAt(v) != '\"' && p.charAt(v) != '\'') {
                        sb.append(p.charAt(v++));
                    }
                    if (debug) {
                        logger.info("unparsed-text(): encoding in XML declaration = " + sb.toString());
                    }
                    return sb.toString();
                }
                if (debug) {
                    logger.info("unparsed-text(): no encoding found in XML declaration");
                }
            }
        } else {
            if (read > 0 && start[0] == 0 && start[2] == 0 && start[4] == 0 && start[6] == 0) {
                if (debug) {
                    logger.info("unparsed-text(): even-numbered bytes are zero, inferring UTF-16");
                }
                return "UTF-16";
            }
            if (read > 1 && start[1] == 0 && start[3] == 0 && start[5] == 0 && start[7] == 0) {
                if (debug) {
                    logger.info("unparsed-text(): odd-numbered bytes are zero, inferring UTF-16LE");
                }
                return "UTF-16LE";
            }
        }
        if (debug) {
            logger.info("unparsed-text(): assuming fallback encoding (UTF-8)");
        }
        return defaultEncoding;
    }

    private static int ch(byte b) {
        return b & 0xFF;
    }
}

