/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Objects;
import java.util.Random;
import org.apache.commons.lang3.CachedRandomBits;
import org.apache.commons.lang3.LangAssertions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class CachedRandomBitsTest {
    CachedRandomBitsTest() {
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 32})
    void testNext(int cacheSize) {
        MockRandom random = new MockRandom(new byte[]{17, 18, 19, 37, -85, -51, -17, -1, 85, 68, 18, 52, 86, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        CachedRandomBits arb = new CachedRandomBits(cacheSize, (Random)random);
        LangAssertions.assertIllegalArgumentException(() -> arb.nextBits(0));
        LangAssertions.assertIllegalArgumentException(() -> arb.nextBits(33));
        Assertions.assertEquals((int)17, (int)arb.nextBits(8));
        Assertions.assertEquals((int)18, (int)arb.nextBits(8));
        Assertions.assertEquals((int)4901, (int)arb.nextBits(16));
        Assertions.assertEquals((int)-1412567041, (int)arb.nextBits(32));
        Assertions.assertEquals((int)5, (int)arb.nextBits(4));
        Assertions.assertEquals((int)1, (int)arb.nextBits(1));
        Assertions.assertEquals((int)0, (int)arb.nextBits(1));
        Assertions.assertEquals((int)1, (int)arb.nextBits(2));
        Assertions.assertEquals((int)4, (int)arb.nextBits(6));
        Assertions.assertEquals((int)1150096824, (int)arb.nextBits(32));
        Assertions.assertEquals((int)1, (int)arb.nextBits(1));
        Assertions.assertEquals((int)0, (int)arb.nextBits(1));
        Assertions.assertEquals((int)0, (int)arb.nextBits(9));
        Assertions.assertEquals((int)0, (int)arb.nextBits(31));
    }

    private static class MockRandom
    extends Random {
        private static final long serialVersionUID = 1L;
        private final byte[] outputs;
        private int index;

        MockRandom(byte[] outputs) {
            this.outputs = (byte[])outputs.clone();
            this.index = 0;
        }

        @Override
        public void nextBytes(byte[] bytes) {
            Objects.requireNonNull(bytes, "bytes");
            if (this.index + bytes.length > this.outputs.length) {
                throw new IllegalStateException("Not enough outputs given in MockRandom");
            }
            System.arraycopy(this.outputs, this.index, bytes, 0, bytes.length);
            this.index += bytes.length;
        }
    }
}

