/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.output.BrokenOutputStream;
import org.apache.commons.io.output.UncheckedFilterOutputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class UncheckedFilterOutputStreamTest {
    private IOException exception;
    private UncheckedFilterOutputStream brokenWriter;
    private UncheckedFilterOutputStream stringWriter;

    UncheckedFilterOutputStreamTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.exception = new IOException("test exception");
        this.brokenWriter = ((UncheckedFilterOutputStream.Builder)UncheckedFilterOutputStream.builder().setOutputStream((OutputStream)new BrokenOutputStream(this.exception))).get();
        this.stringWriter = ((UncheckedFilterOutputStream.Builder)UncheckedFilterOutputStream.builder().setOutputStream((OutputStream)((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter((Writer)new StringWriter())).setCharset(Charset.defaultCharset()).get())).get();
    }

    @Test
    void testClose() {
        this.stringWriter.close();
    }

    @Test
    void testCloseThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.close())).getCause());
    }

    @Test
    void testEquals() {
        this.stringWriter.equals(null);
    }

    @Test
    @Disabled(value="What should happen here?")
    void testEqualsThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.equals(null))).getCause());
    }

    @Test
    void testFlush() {
        this.stringWriter.flush();
    }

    @Test
    void testFlushThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.flush())).getCause());
    }

    @Test
    void testHashCode() {
        this.stringWriter.hashCode();
    }

    @Test
    @Disabled(value="What should happen here?")
    void testHashCodeThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.hashCode())).getCause());
    }

    @Test
    void testToString() {
        this.stringWriter.toString();
    }

    @Test
    @Disabled(value="What should happen here?")
    void testToStringThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.toString())).getCause());
    }

    @Test
    void testWriteInt() {
        this.stringWriter.write(1);
    }

    @Test
    void testWriteIntThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.brokenWriter.write(1))).getCause());
    }
}

