/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.cipher.CryptoCipherFactory;

public final class Utils {
    private static final String SYSTEM_PROPERTIES_FILE = "commons.crypto.properties";

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    @Deprecated
    public static <T> T checkNotNull(T reference) {
        return Objects.requireNonNull(reference, "reference");
    }

    public static void checkState(boolean expression) {
        Utils.checkState(expression, null);
    }

    public static void checkState(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static CryptoCipher getCipherInstance(String transformation, Properties properties) throws IOException {
        try {
            return CryptoCipherFactory.getCryptoCipher(transformation, properties);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public static Properties getDefaultProperties() {
        return new Properties(DefaultPropertiesHolder.DEFAULT_PROPERTIES);
    }

    public static Properties getProperties(Properties newProp) {
        Properties properties = new Properties(DefaultPropertiesHolder.DEFAULT_PROPERTIES);
        properties.putAll((Map<?, ?>)newProp);
        return properties;
    }

    static String libraryPath(String name) {
        String override = System.getProperty("jni.library.path");
        if (override != null && new File(override).isDirectory()) {
            return new File(override, name).getPath();
        }
        return name;
    }

    public static List<String> splitClassNames(String clazzNames, String separator) {
        ArrayList<String> res = new ArrayList<String>();
        if (clazzNames == null || clazzNames.isEmpty()) {
            return res;
        }
        String[] stringArray = clazzNames.split(separator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String clazzName = stringArray[n2];
            if (!(clazzName = clazzName.trim()).isEmpty()) {
                res.add(clazzName);
            }
            ++n2;
        }
        return res;
    }

    private Utils() {
    }

    private static class DefaultPropertiesHolder {
        static final Properties DEFAULT_PROPERTIES = DefaultPropertiesHolder.createDefaultProperties();

        private DefaultPropertiesHolder() {
        }

        private static Properties createDefaultProperties() {
            Properties defaultedProps = new Properties(System.getProperties());
            URL url = Thread.currentThread().getContextClassLoader().getResource(Utils.SYSTEM_PROPERTIES_FILE);
            if (url == null) {
                return defaultedProps;
            }
            try {
                Properties fileProps = new Properties();
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = url.openStream();){
                    fileProps.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                Enumeration<?> names = fileProps.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    if (System.getProperty(name) != null) continue;
                    defaultedProps.setProperty(name, fileProps.getProperty(name));
                }
            }
            catch (Exception ex) {
                System.err.println("Could not load 'commons.crypto.properties' from classpath: " + ex.toString());
            }
            return defaultedProps;
        }
    }
}

