/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractStringEncoderTest<T extends StringEncoder> {
    protected T stringEncoder = this.createStringEncoder();

    public void checkEncoding(String expected, String source) throws EncoderException {
        Assertions.assertEquals((Object)expected, (Object)this.getStringEncoder().encode(source), (String)("Source: " + source));
    }

    protected void checkEncodings(String[][] data) throws EncoderException {
        for (String[] element : data) {
            this.checkEncoding(element[1], element[0]);
        }
    }

    protected void checkEncodingVariations(String expected, String ... data) throws EncoderException {
        for (String element : data) {
            this.checkEncoding(expected, element);
        }
    }

    protected abstract T createStringEncoder();

    public T getStringEncoder() {
        return this.stringEncoder;
    }

    @Test
    void testEncodeEmpty() throws Exception {
        T encoder = this.getStringEncoder();
        encoder.encode((Object)"");
        encoder.encode((Object)" ");
        encoder.encode((Object)"\t");
    }

    @Test
    void testEncodeNull() throws EncoderException {
        T encoder = this.getStringEncoder();
        encoder.encode(null);
    }

    @Test
    void testEncodeWithInvalidObject() throws Exception {
        Object encoder = this.getStringEncoder();
        Assertions.assertThrows(EncoderException.class, () -> encoder.encode((Object)Float.valueOf(3.4f)), (String)"An exception was not thrown when we tried to encode a Float object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLocaleIndependence() throws Exception {
        T encoder = this.getStringEncoder();
        String[] data = new String[]{"I", "i"};
        Locale orig = Locale.getDefault();
        Locale[] locales = new Locale[]{Locale.ENGLISH, new Locale("tr"), Locale.getDefault()};
        try {
            for (String element : data) {
                String ref = null;
                for (int j = 0; j < locales.length; ++j) {
                    Locale.setDefault(locales[j]);
                    if (j <= 0) {
                        ref = encoder.encode(element);
                        continue;
                    }
                    String cur = null;
                    try {
                        cur = encoder.encode(element);
                    }
                    catch (Exception e) {
                        Assertions.fail((String)(Locale.getDefault().toString() + ": " + e.getMessage()));
                    }
                    Assertions.assertEquals((Object)ref, (Object)cur, (String)(Locale.getDefault().toString() + ": "));
                }
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }
}

