/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.peer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.shell.cli.RaftUtils;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;

public class SetPriorityCommand
extends AbstractRatisCommand {
    public static final String PEER_WITH_NEW_PRIORITY_OPTION_NAME = "addressPriority";

    public SetPriorityCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "setPriority";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        super.run(cl);
        HashMap<String, Integer> addressPriorityMap = new HashMap<String, Integer>();
        for (String optionValue : cl.getOptionValues(PEER_WITH_NEW_PRIORITY_OPTION_NAME)) {
            String[] str = optionValue.split("[|]");
            if (str.length < 2) {
                this.println("The format of the parameter is wrong");
                return -1;
            }
            addressPriorityMap.put(str[0], Integer.parseInt(str[1]));
        }
        try (RaftClient client = RaftUtils.createClient(this.getRaftGroup());){
            List peers = this.getPeerStream(RaftProtos.RaftPeerRole.FOLLOWER).map(peer -> {
                Integer newPriority = (Integer)addressPriorityMap.get(peer.getAddress());
                int priority = newPriority != null ? newPriority.intValue() : peer.getPriority();
                return RaftPeer.newBuilder((RaftPeer)peer).setPriority(priority).build();
            }).collect(Collectors.toList());
            List listeners = this.getPeerStream(RaftProtos.RaftPeerRole.LISTENER).collect(Collectors.toList());
            RaftClientReply reply = client.admin().setConfiguration(peers, listeners);
            this.processReply(reply, () -> "Failed to set master priorities ");
        }
        return 0;
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> [-%s <RAFT_GROUP_ID>] -%s <PEER_HOST:PEER_PORT|PRIORITY>", this.getCommandName(), "peers", "groupid", PEER_WITH_NEW_PRIORITY_OPTION_NAME);
    }

    @Override
    public String getDescription() {
        return SetPriorityCommand.description();
    }

    @Override
    public Options getOptions() {
        return super.getOptions().addOption(Option.builder().option(PEER_WITH_NEW_PRIORITY_OPTION_NAME).hasArg().required().desc("Peers information with priority").build());
    }

    public static String description() {
        return "Set priority to ratis peers";
    }
}

