/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import org.roaringbitmap.art.AbstractShuttle;
import org.roaringbitmap.art.Art;
import org.roaringbitmap.art.Containers;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.SearchResult;
import org.roaringbitmap.longlong.LongUtils;

public class BackwardShuttle
extends AbstractShuttle {
    BackwardShuttle(Art art, Containers containers) {
        super(art, containers);
    }

    @Override
    protected boolean currentBeforeHigh(byte[] current, byte[] high) {
        return LongUtils.compareHigh(current, high) > 0;
    }

    @Override
    protected int visitedNodeNextPosition(Node node, int pos) {
        return node.getNextSmallerPos(pos);
    }

    @Override
    protected int boundaryNodePosition(Node node, boolean inRunDirection) {
        if (inRunDirection) {
            return node.getMinPos();
        }
        return node.getMaxPos();
    }

    @Override
    protected boolean prefixMismatchIsInRunDirection(byte nodeValue, byte highValue) {
        return Byte.toUnsignedInt(nodeValue) > Byte.toUnsignedInt(highValue);
    }

    @Override
    protected int searchMissNextPosition(SearchResult result) {
        return result.getNextSmallerPos();
    }
}

