/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.ext.web.handler.HttpException;
import java.io.File;
import java.util.Objects;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.config.CassandraInputValidationConfiguration;
import org.apache.cassandra.sidecar.config.yaml.CassandraInputValidationConfigurationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class CassandraInputValidator {
    private final CassandraInputValidationConfiguration validationConfiguration;

    @Inject
    public CassandraInputValidator(CassandraInputValidationConfiguration validationConfiguration) {
        this.validationConfiguration = validationConfiguration;
    }

    @VisibleForTesting
    public CassandraInputValidator() {
        this(new CassandraInputValidationConfigurationImpl());
    }

    public Name validateKeyspaceName(@NotNull String keyspace) {
        Name name = new Name(keyspace);
        this.validateNamePattern(name, "keyspace");
        if (this.validationConfiguration.forbiddenKeyspaces().contains(name.name())) {
            throw new HttpException(HttpResponseStatus.FORBIDDEN.code(), "Forbidden keyspace: " + keyspace);
        }
        return name;
    }

    public Name validateTableName(@NotNull String tableName) {
        Name name = new Name(tableName);
        this.validateNamePattern(name, "table name");
        return name;
    }

    public String validateSnapshotName(@NotNull String snapshotName) {
        Objects.requireNonNull(snapshotName, "snapshotName must not be null");
        if (snapshotName.contains(File.separator) || snapshotName.contains("\u0000")) {
            throw new HttpException(HttpResponseStatus.BAD_REQUEST.code(), "Invalid characters in snapshot name: " + snapshotName);
        }
        return snapshotName;
    }

    public String validateComponentName(@NotNull String componentName) {
        return this.validateComponentNameByRegex(componentName, this.validationConfiguration.allowedPatternForComponentName());
    }

    public String validateRestrictedComponentName(@NotNull String componentName) {
        return this.validateComponentNameByRegex(componentName, this.validationConfiguration.allowedPatternForRestrictedComponentName());
    }

    @NotNull
    private String validateComponentNameByRegex(String componentName, String regex) {
        Objects.requireNonNull(componentName, "componentName must not be null");
        if (!componentName.matches(regex)) {
            throw new HttpException(HttpResponseStatus.BAD_REQUEST.code(), "Invalid component name: " + componentName);
        }
        return componentName;
    }

    public void validatePattern(String unquotedInput, String maybeQuoted, String exceptionHint, boolean isQuotedFromSource) {
        String pattern;
        String string = pattern = isQuotedFromSource ? this.validationConfiguration.allowedPatternForQuotedName() : this.validationConfiguration.allowedPatternForName();
        if (!unquotedInput.matches(pattern)) {
            throw new HttpException(HttpResponseStatus.BAD_REQUEST.code(), "Invalid characters in " + exceptionHint + ": " + maybeQuoted);
        }
    }

    public void validateTableId(String tableId) {
        Objects.requireNonNull(tableId, "tableId must not be null");
        Preconditions.checkArgument((tableId.length() <= 32 ? 1 : 0) != 0, (String)"tableId cannot be longer than 32 characters");
        for (int i = 0; i < tableId.length(); ++i) {
            char c = tableId.charAt(i);
            if (this.isHex(c)) continue;
            throw new HttpException(HttpResponseStatus.BAD_REQUEST.code(), "Invalid characters in table id: " + tableId);
        }
    }

    protected boolean isHex(char c) {
        return c >= 'a' && c <= 'f' || c >= '0' && c <= '9' || c >= 'A' && c <= 'F';
    }

    public void validateNamePattern(Name name, String exceptionHint) {
        this.validatePattern(name.name(), name.maybeQuotedName(), exceptionHint, name.isSourceQuoted());
    }
}

