/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules.multibindings;

import io.vertx.core.http.HttpMethod;
import org.apache.cassandra.sidecar.modules.multibindings.ClassKey;

public interface RouteClassKey
extends ClassKey {
    public static final String HTTP_METHOD_FIELD_NAME = "HTTP_METHOD";
    public static final String ROUTE_URI_FIELD_NAME = "ROUTE_URI";

    public static HttpMethod httpMethod(Class<? extends RouteClassKey> classKey) {
        return RouteClassKey.readStaticFieldValue(classKey, HTTP_METHOD_FIELD_NAME, HttpMethod.class);
    }

    public static String routeURI(Class<? extends RouteClassKey> classKey) {
        return RouteClassKey.readStaticFieldValue(classKey, ROUTE_URI_FIELD_NAME, String.class);
    }

    private static <T> T readStaticFieldValue(Class<? extends RouteClassKey> classKey, String declaredFieldName, Class<T> expectedType) {
        try {
            return expectedType.cast(classKey.getDeclaredField(declaredFieldName).get(null));
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

