/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TokenRange;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.schema.CQLTypeParser;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.DroppedColumn;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.utils.FBUtilities;

public class NativeSSTableLoaderClient
extends SSTableLoader.Client {
    protected final Map<String, TableMetadataRef> tables = new HashMap<String, TableMetadataRef>();
    private final Collection<InetSocketAddress> hosts;
    private final int storagePort;
    private final AuthProvider authProvider;
    private final SSLOptions sslOptions;

    public NativeSSTableLoaderClient(Collection<InetSocketAddress> hosts, int storagePort, String username, String password, SSLOptions sslOptions) {
        this(hosts, storagePort, (AuthProvider)new PlainTextAuthProvider(username, password), sslOptions);
    }

    public NativeSSTableLoaderClient(Collection<InetSocketAddress> hosts, int storagePort, AuthProvider authProvider, SSLOptions sslOptions) {
        this.hosts = hosts;
        this.authProvider = authProvider;
        this.sslOptions = sslOptions;
        this.storagePort = storagePort;
    }

    @Override
    public void init(String keyspace) {
        Cluster.Builder builder = Cluster.builder().addContactPointsWithPorts(this.hosts).allowBetaProtocolVersion();
        if (this.sslOptions != null) {
            builder.withSSL(this.sslOptions);
        }
        if (this.authProvider != null) {
            builder = builder.withAuthProvider(this.authProvider);
        }
        try (Cluster cluster = builder.build();
             Session session = cluster.connect();){
            Metadata metadata = cluster.getMetadata();
            Set tokenRanges = metadata.getTokenRanges();
            IPartitioner partitioner = FBUtilities.newPartitioner(metadata.getPartitioner());
            Token.TokenFactory tokenFactory = partitioner.getTokenFactory();
            for (TokenRange tokenRange : tokenRanges) {
                Set endpoints = metadata.getReplicas(Metadata.quote((String)keyspace), tokenRange);
                Range<Token> range = new Range<Token>(tokenFactory.fromString(tokenRange.getStart().getValue().toString()), tokenFactory.fromString(tokenRange.getEnd().getValue().toString()));
                for (Host endpoint : endpoints) {
                    int broadcastPort = endpoint.getBroadcastSocketAddress().getPort();
                    int portToUse = broadcastPort != 0 ? broadcastPort : this.storagePort;
                    this.addRangeForEndpoint(range, InetAddressAndPort.getByNameOverrideDefaults(endpoint.getAddress().getHostAddress(), portToUse));
                }
            }
            Types types = NativeSSTableLoaderClient.fetchTypes(keyspace, session);
            this.tables.putAll(NativeSSTableLoaderClient.fetchTables(keyspace, session, partitioner, types));
            this.tables.putAll(NativeSSTableLoaderClient.fetchViews(keyspace, session, partitioner, types));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialise " + NativeSSTableLoaderClient.class.getName(), e);
        }
    }

    @Override
    public TableMetadataRef getTableMetadata(String tableName) {
        return this.tables.get(tableName);
    }

    @Override
    public void setTableMetadata(TableMetadataRef cfm) {
        this.tables.put(cfm.name, cfm);
    }

    private static Types fetchTypes(String keyspace, Session session) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "types");
        Types.RawBuilder types = Types.rawBuilder(keyspace);
        for (Row row : session.execute(query, new Object[]{keyspace})) {
            String name = row.getString("type_name");
            List fieldNames = row.getList("field_names", String.class);
            List fieldTypes = row.getList("field_types", String.class);
            types.add(name, fieldNames, fieldTypes);
        }
        return types.build();
    }

    private static Map<String, TableMetadataRef> fetchTables(String keyspace, Session session, IPartitioner partitioner, Types types) {
        HashMap<String, TableMetadataRef> tables = new HashMap<String, TableMetadataRef>();
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "tables");
        for (Row row : session.execute(query, new Object[]{keyspace})) {
            String name = row.getString("table_name");
            tables.put(name, NativeSSTableLoaderClient.createTableMetadata(keyspace, session, partitioner, false, row, name, types));
        }
        return tables;
    }

    private static Map<String, TableMetadataRef> fetchViews(String keyspace, Session session, IPartitioner partitioner, Types types) {
        HashMap<String, TableMetadataRef> tables = new HashMap<String, TableMetadataRef>();
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "views");
        for (Row row : session.execute(query, new Object[]{keyspace})) {
            String name = row.getString("view_name");
            tables.put(name, NativeSSTableLoaderClient.createTableMetadata(keyspace, session, partitioner, true, row, name, types));
        }
        return tables;
    }

    private static TableMetadataRef createTableMetadata(String keyspace, Session session, IPartitioner partitioner, boolean isView, Row row, String name, Types types) {
        TableMetadata.Builder builder = TableMetadata.builder(keyspace, name, TableId.fromUUID(row.getUUID("id"))).partitioner(partitioner);
        if (!isView) {
            builder.flags(TableMetadata.Flag.fromStringSet(row.getSet("flags", String.class)));
        }
        String columnsQuery = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", "columns");
        for (Row colRow : session.execute(columnsQuery, new Object[]{keyspace, name})) {
            builder.addColumn(NativeSSTableLoaderClient.createDefinitionFromRow(colRow, keyspace, name, types));
        }
        String droppedColumnsQuery = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", "dropped_columns");
        HashMap<ByteBuffer, DroppedColumn> droppedColumns = new HashMap<ByteBuffer, DroppedColumn>();
        for (Row colRow : session.execute(droppedColumnsQuery, new Object[]{keyspace, name})) {
            DroppedColumn droppedColumn = NativeSSTableLoaderClient.createDroppedColumnFromRow(colRow, keyspace, name);
            droppedColumns.put(droppedColumn.column.name.bytes, droppedColumn);
        }
        builder.droppedColumns(droppedColumns);
        return TableMetadataRef.forOfflineTools(builder.build());
    }

    private static ColumnMetadata createDefinitionFromRow(Row row, String keyspace, String table, Types types) {
        ColumnMetadata.ClusteringOrder order = ColumnMetadata.ClusteringOrder.valueOf(row.getString("clustering_order").toUpperCase());
        AbstractType<?> type = CQLTypeParser.parse(keyspace, row.getString("type"), types);
        if (order == ColumnMetadata.ClusteringOrder.DESC) {
            type = ReversedType.getInstance(type);
        }
        ColumnIdentifier name = new ColumnIdentifier(row.getBytes("column_name_bytes"), row.getString("column_name"));
        int position = row.getInt("position");
        ColumnMetadata.Kind kind = ColumnMetadata.Kind.valueOf(row.getString("kind").toUpperCase());
        return new ColumnMetadata(keyspace, table, name, type, position, kind, null);
    }

    private static DroppedColumn createDroppedColumnFromRow(Row row, String keyspace, String table) {
        String name = row.getString("column_name");
        AbstractType<?> type = CQLTypeParser.parse(keyspace, row.getString("type"), Types.none());
        ColumnMetadata.Kind kind = ColumnMetadata.Kind.valueOf(row.getString("kind").toUpperCase());
        ColumnMetadata column = new ColumnMetadata(keyspace, table, ColumnIdentifier.getInterned(name, true), type, -1, kind, null);
        long droppedTime = row.getTimestamp("dropped_time").getTime();
        return new DroppedColumn(column, droppedTime);
    }
}

