/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.IOException;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.io.IndexOutputWriter;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;

public class ColumnCompletionMarkerUtil {
    private static final byte EMPTY = 1;
    private static final byte NOT_EMPTY = 0;

    public static void create(IndexDescriptor descriptor, IndexIdentifier indexIdentifier, boolean isEmpty) throws IOException {
        try (IndexOutputWriter output = descriptor.openPerIndexOutput(IndexComponent.COLUMN_COMPLETION_MARKER, indexIdentifier);){
            SAICodecUtils.writeHeader(output);
            output.writeByte(isEmpty ? (byte)1 : 0);
            SAICodecUtils.writeFooter(output);
        }
    }

    public static boolean isEmptyIndex(IndexDescriptor descriptor, IndexIdentifier indexIdentifier) throws IOException {
        try (IndexInput input = descriptor.openPerIndexInput(IndexComponent.COLUMN_COMPLETION_MARKER, indexIdentifier);){
            SAICodecUtils.checkHeader((DataInput)input);
            boolean bl = input.readByte() == 1;
            return bl;
        }
    }
}

