/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cassandra.concurrent.ExecutorLocal;

public class ClientWarn
implements ExecutorLocal<State> {
    private static final String TRUNCATED = " [truncated]";
    private static final FastThreadLocal<State> warnLocal = new FastThreadLocal();
    public static ClientWarn instance = new ClientWarn();

    private ClientWarn() {
    }

    @Override
    public State get() {
        return (State)warnLocal.get();
    }

    @Override
    public void set(State value) {
        warnLocal.set((Object)value);
    }

    public void warn(String text) {
        State state = (State)warnLocal.get();
        if (state != null) {
            state.add(text);
        }
    }

    public void captureWarnings() {
        warnLocal.set((Object)new State());
    }

    public List<String> getWarnings() {
        State state = (State)warnLocal.get();
        if (state == null || state.warnings.isEmpty()) {
            return null;
        }
        return state.warnings;
    }

    public void resetWarnings() {
        warnLocal.remove();
    }

    public static class State {
        private final List<String> warnings = new CopyOnWriteArrayList<String>();

        private void add(String warning) {
            if (this.warnings.size() < 65535) {
                this.warnings.add(State.maybeTruncate(warning));
            }
        }

        private static String maybeTruncate(String warning) {
            return warning.length() > 65535 ? warning.substring(0, 65535 - ClientWarn.TRUNCATED.length()) + ClientWarn.TRUNCATED : warning;
        }
    }
}

