/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.selection.ResultSetBuilder;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

final class WritetimeOrTTLSelector
extends Selector {
    private final ColumnMetadata column;
    private final int idx;
    private final boolean isWritetime;
    private ByteBuffer current;
    private boolean isSet;

    public static Selector.Factory newFactory(final ColumnMetadata def, final int idx, final boolean isWritetime) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return String.format("%s(%s)", isWritetime ? "writetime" : "ttl", def.name.toString());
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return isWritetime ? LongType.instance : Int32Type.instance;
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
                mapping.addMapping(resultsColumn, def);
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                return new WritetimeOrTTLSelector(def, idx, isWritetime);
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                return isWritetime;
            }

            @Override
            public boolean isTTLSelectorFactory() {
                return !isWritetime;
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return true;
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
                builder.add(def);
            }
        };
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        builder.add(this.column);
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, ResultSetBuilder rs) {
        int ttl;
        long ts;
        if (this.isSet) {
            return;
        }
        this.isSet = true;
        this.current = this.isWritetime ? ((ts = rs.timestamps[this.idx]) != Long.MIN_VALUE ? ByteBufferUtil.bytes(ts) : null) : ((ttl = rs.ttls[this.idx]) > 0 ? ByteBufferUtil.bytes(ttl) : null);
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        return this.current;
    }

    @Override
    public void reset() {
        this.isSet = false;
        this.current = null;
    }

    @Override
    public AbstractType<?> getType() {
        return this.isWritetime ? LongType.instance : Int32Type.instance;
    }

    public String toString() {
        return this.column.name.toString();
    }

    private WritetimeOrTTLSelector(ColumnMetadata column, int idx, boolean isWritetime) {
        this.column = column;
        this.idx = idx;
        this.isWritetime = isWritetime;
    }
}

