/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.hints.Hint;
import org.apache.cassandra.hints.HintMessage;
import org.apache.cassandra.hints.HintResponse;
import org.apache.cassandra.hints.HintsService;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HintVerbHandler
implements IVerbHandler<HintMessage> {
    private static final Logger logger = LoggerFactory.getLogger(HintVerbHandler.class);

    @Override
    public void doVerb(MessageIn<HintMessage> message, int id) {
        UUID hostId = ((HintMessage)message.payload).hostId;
        Hint hint = ((HintMessage)message.payload).hint;
        InetAddress address = StorageService.instance.getEndpointForHostId(hostId);
        if (hint == null) {
            logger.trace("Failed to decode and apply a hint for {}: {} - table with id {} is unknown", new Object[]{address, hostId, ((HintMessage)message.payload).unknownTableID});
            HintVerbHandler.reply(id, message.from);
            return;
        }
        try {
            hint.mutation.getPartitionUpdates().forEach(PartitionUpdate::validate);
        }
        catch (MarshalException e2) {
            logger.warn("Failed to validate a hint for {}: {} - skipped", (Object)address, (Object)hostId);
            HintVerbHandler.reply(id, message.from);
            return;
        }
        if (!hostId.equals(StorageService.instance.getLocalHostUUID())) {
            HintsService.instance.write(hostId, hint);
            HintVerbHandler.reply(id, message.from);
        } else if (!StorageProxy.instance.appliesLocally(hint.mutation)) {
            HintsService.instance.writeForAllReplicas(hint);
            HintVerbHandler.reply(id, message.from);
        } else {
            ((CompletableFuture)hint.applyFuture().thenAccept(o -> HintVerbHandler.reply(id, message.from))).exceptionally(e -> {
                logger.debug("Failed to apply hint", e);
                return null;
            });
        }
    }

    private static void reply(int id, InetAddress to) {
        MessagingService.instance().sendReply(HintResponse.message, id, to);
    }
}

