/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.net.InetAddress;
import java.util.Map;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigestAck2;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDigestAck2VerbHandler
implements IVerbHandler<GossipDigestAck2> {
    private static final Logger logger = LoggerFactory.getLogger(GossipDigestAck2VerbHandler.class);

    @Override
    public void doVerb(MessageIn<GossipDigestAck2> message, int id) {
        if (logger.isTraceEnabled()) {
            InetAddress from = message.from;
            logger.trace("Received a GossipDigestAck2Message from {}", (Object)from);
        }
        if (!Gossiper.instance.isEnabled()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Ignoring GossipDigestAck2Message because gossip is disabled");
            }
            return;
        }
        Map<InetAddress, EndpointState> remoteEpStateMap = ((GossipDigestAck2)message.payload).getEndpointStateMap();
        Gossiper.instance.notifyFailureDetector(remoteEpStateMap);
        Gossiper.instance.applyStateLocally(remoteEpStateMap);
    }
}

