/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.typereg.BrooklynTypePlanTransformer;
import org.apache.brooklyn.core.typereg.RegisteredTypeKindVisitor;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTypePlanTransformer
implements BrooklynTypePlanTransformer {
    private static final Logger log = LoggerFactory.getLogger(AbstractTypePlanTransformer.class);
    protected ManagementContext mgmt;
    private final String format;
    private final String formatName;
    private final String formatDescription;

    @Override
    public void setManagementContext(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    protected AbstractTypePlanTransformer(String format, String formatName, String formatDescription) {
        this.format = format;
        this.formatName = formatName;
        this.formatDescription = formatDescription;
    }

    @Override
    public String getFormatCode() {
        return this.format;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public String getFormatDescription() {
        return this.formatDescription;
    }

    public String toString() {
        return this.getFormatCode() + ":" + JavaClassNames.simpleClassName((Object)this);
    }

    @Override
    public double scoreForType(RegisteredType type, RegisteredTypeLoadingContext context) {
        if (this.getFormatCode().equals(type.getPlan().getPlanFormat())) {
            return 1.0;
        }
        if (Strings.isBlank((CharSequence)type.getPlan().getPlanFormat())) {
            return this.scoreForNullFormat(type.getPlan().getPlanData(), type, context);
        }
        return this.scoreForNonmatchingNonnullFormat(type.getPlan().getPlanFormat(), type.getPlan().getPlanData(), type, context);
    }

    protected abstract double scoreForNullFormat(Object var1, RegisteredType var2, RegisteredTypeLoadingContext var3);

    protected abstract double scoreForNonmatchingNonnullFormat(String var1, Object var2, RegisteredType var3, RegisteredTypeLoadingContext var4);

    @Override
    public Object create(final RegisteredType type, final RegisteredTypeLoadingContext context) {
        try {
            return this.tryValidate(new RegisteredTypeKindVisitor<Object>(){

                @Override
                protected Object visitSpec() {
                    try {
                        AbstractBrooklynObjectSpec<?, ?> result = AbstractTypePlanTransformer.this.createSpec(type, context);
                        result.stackCatalogItemId(type.getId());
                        return result;
                    }
                    catch (Exception e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }

                @Override
                protected Object visitBean() {
                    try {
                        return AbstractTypePlanTransformer.this.createBean(type, context);
                    }
                    catch (Exception e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }

                @Override
                protected Object visitUnresolved() {
                    try {
                        log.debug("Request for " + this + " to validate UNRESOLVED kind " + type + "; trying as spec");
                        Object result = this.visitSpec();
                        log.warn("Request to use " + this + " from UNRESOLVED state succeeded treating is as a spec");
                        log.debug("Trace for request to use " + this + " in UNRESOLVED state succeeding", new Throwable("Location of request to use " + this + " in UNRESOLVED state"));
                        return result;
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        throw new IllegalStateException(type + " is in registry but its definition cannot be resolved", e);
                    }
                }
            }.visit(type.getKind()), type, context).get();
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            if (!(e instanceof UnsupportedTypePlanException)) {
                Supplier<String> s = () -> "Could not instantiate " + type + " (rethrowing): " + Exceptions.collapseText((Throwable)e);
                if (BasicBrooklynCatalog.currentlyResolvingType.get() == null) {
                    log.debug(s.get());
                } else if (log.isTraceEnabled()) {
                    log.trace(s.get());
                }
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected <T> Maybe<T> tryValidate(T createdObject, RegisteredType type, RegisteredTypeLoadingContext constraint) {
        return RegisteredTypes.tryValidate(createdObject, type, constraint);
    }

    protected abstract AbstractBrooklynObjectSpec<?, ?> createSpec(RegisteredType var1, RegisteredTypeLoadingContext var2) throws Exception;

    protected abstract Object createBean(RegisteredType var1, RegisteredTypeLoadingContext var2) throws Exception;

    @Deprecated
    @Beta
    protected AbstractBrooklynObjectSpec<?, ?> decorateWithCommonTags(AbstractBrooklynObjectSpec<?, ?> spec, RegisteredType type, @Nullable String format, @Nullable String summary, @Nullable Function<String, String> previousSummaryModification) {
        return this.decorateWithCommonTagsModifyingSpecSummary(spec, type, format, summary, previousSummaryModification == null ? null : s -> (String)previousSummaryModification.apply(s.summary));
    }

    @Beta
    protected AbstractBrooklynObjectSpec<?, ?> decorateWithCommonTagsModifyingSpecSummary(AbstractBrooklynObjectSpec<?, ?> spec, RegisteredType type, @Nullable String format, @Nullable String summary, @Nullable Function<BrooklynTags.SpecSummary, String> previousSummaryModification) {
        if (Strings.isBlank((CharSequence)format)) {
            format = this.getFormatCode();
        }
        String specSummaryText = Strings.isNonBlank((CharSequence)summary) ? summary : format + " plan" + (Strings.isNonBlank((CharSequence)type.getSymbolicName()) ? " for type " + type.getSymbolicName() : (Strings.isNonBlank((CharSequence)type.getDisplayName()) ? " for " + type.getDisplayName() : ""));
        BrooklynTags.SpecSummary specSummary = BrooklynTags.SpecSummary.builder().format(format).summary(specSummaryText).contents(type.getPlan().getPlanData()).build();
        MutableList specTag = BrooklynTags.findSpecHierarchyTag(spec.getTags());
        if (specTag != null) {
            BrooklynTags.SpecSummary.modifyHeadSpecSummary(specTag, previousSummaryModification);
            BrooklynTags.SpecSummary.pushToList((List<BrooklynTags.SpecSummary>)specTag, specSummary);
        } else {
            specTag = MutableList.of((Object)specSummary);
        }
        List<BrooklynTags.SpecSummary> sources = BrooklynTags.findSpecHierarchyTag(type.getTags());
        if (sources != null) {
            BrooklynTags.SpecSummary.modifyHeadSpecSummary((List<BrooklynTags.SpecSummary>)specTag, s -> s.summary.startsWith(s.format) ? "Converted for catalog to " + s.summary : (s.summary.contains(s.format) ? s.summary + ", converted for catalog" : s.summary + ", converted to " + s.format + " for catalog"));
            BrooklynTags.SpecSummary.pushToList((List<BrooklynTags.SpecSummary>)specTag, sources);
        }
        BrooklynTags.upsertSingleKeyMapValueTag(spec, "spec_hierarchy", specTag);
        if (spec instanceof EntitySpec) {
            this.addDepthTagsWhereMissing(((EntitySpec)spec).getChildren(), 1);
        }
        AbstractTypePlanTransformer.checkSecuritySensitiveFields(spec);
        return spec;
    }

    protected void addDepthTagsWhereMissing(List<EntitySpec<?>> children, int depth) {
        children.forEach(c -> {
            Integer existingDepth = BrooklynTags.getDepthInAncestorTag(c.getTags());
            if (existingDepth == null) {
                c.tag((Object)MutableMap.of((Object)"depth_in_ancestor", (Object)depth));
                this.addDepthTagsWhereMissing(c.getChildren(), depth + 1);
            }
        });
    }

    @Beta
    public static AbstractBrooklynObjectSpec<?, ?> checkSecuritySensitiveFields(AbstractBrooklynObjectSpec<?, ?> spec) {
        if (Sanitizer.isSensitiveFieldsPlaintextBlocked()) {
            Predicate<Object> predicate = Sanitizer.IS_SECRET_PREDICATE;
            spec.getConfig().forEach((key, val) -> AbstractTypePlanTransformer.failOnInsecureValueForSensitiveNamedField(predicate, key.getName(), val));
            spec.getFlags().forEach((key, val) -> AbstractTypePlanTransformer.failOnInsecureValueForSensitiveNamedField(predicate, key, val));
        }
        return spec;
    }

    public static void failOnInsecureValueForSensitiveNamedField(Predicate<Object> tokens, String key, Object val) {
        if (val == null) {
            return;
        }
        if (!tokens.apply((Object)key)) {
            return;
        }
        if (val instanceof DeferredSupplier || val == null) {
            AbstractTypePlanTransformer.failOnExtBlockedPhraseInValueForSensitiveNamedField(key, val);
            return;
        }
        if (val instanceof String && ((String)val).startsWith("$brooklyn:")) {
            AbstractTypePlanTransformer.failOnExtBlockedPhraseInValueForSensitiveNamedField(key, val);
            return;
        }
        if (val instanceof String || Boxing.isPrimitiveOrBoxedClass(val.getClass()) || val instanceof Number) {
            throw new IllegalStateException("Insecure value supplied for '" + key + "'; external suppliers should be used here");
        }
        AbstractTypePlanTransformer.failOnExtBlockedPhraseInValueForSensitiveNamedField(key, val);
    }

    private static void failOnExtBlockedPhraseInValueForSensitiveNamedField(String key, Object value) {
        List<String> blockedPhrases = Sanitizer.getSensitiveFieldsExtBlockedPhrases();
        if (blockedPhrases == null || blockedPhrases.isEmpty()) {
            return;
        }
        String valS = "" + value;
        for (String blockedPhrase : blockedPhrases) {
            if (!valS.contains(blockedPhrase)) continue;
            throw new IllegalStateException("Improperly secured value supplied for '" + key + "'; value must not contain '" + blockedPhrase + "'");
        }
    }
}

