/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.brooklyn.core.resolve.jackson.JsonSymbolDependentDeserializer;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;

@JsonDeserialize(using=PrimitiveTokenOrExpectedObjectDeserializer.class)
public class PrimitiveTokenOrExpectedObject<T> {
    public T object;
    public Object primitive;

    public boolean hasObject() {
        return this.object != null;
    }

    public boolean hasPrimitive() {
        return this.primitive != null;
    }

    public boolean hasStringPrimitive() {
        return this.primitive instanceof String;
    }

    public T asObject() {
        return this.object;
    }

    public Object asPrimitive() {
        return this.primitive;
    }

    public String asString() {
        if (this.hasStringPrimitive()) {
            return (String)this.primitive;
        }
        return null;
    }

    public static class PrimitiveTokenOrExpectedObjectDeserializer
    extends JsonSymbolDependentDeserializer {
        @Override
        public JavaType getDefaultType() {
            return this.ctxt.constructType(Object.class);
        }

        protected Maybe<Object> getTokenValue(JsonToken token, JsonParser p) {
            try {
                if (SIMPLE_TOKENS.contains(token)) {
                    if (JsonToken.VALUE_STRING.equals((Object)token)) {
                        return Maybe.of((Object)p.getValueAsString());
                    }
                    if (JsonToken.VALUE_NUMBER_INT.equals((Object)token)) {
                        return Maybe.of((Object)p.getValueAsInt());
                    }
                    if (JsonToken.VALUE_NUMBER_FLOAT.equals((Object)token)) {
                        return Maybe.of((Object)p.getValueAsDouble());
                    }
                    if (token.isBoolean()) {
                        return Maybe.of((Object)p.getValueAsBoolean());
                    }
                    if (JsonToken.VALUE_NULL.equals((Object)token)) {
                        return Maybe.ofAllowingNull(null);
                    }
                }
                return Maybe.absent();
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        @Override
        protected Object deserializeToken(JsonParser p) throws IOException {
            PrimitiveTokenOrExpectedObject result = new PrimitiveTokenOrExpectedObject();
            result.primitive = this.getTokenValue(p.getCurrentToken(), p).get();
            return result;
        }

        @Override
        protected Object deserializeObject(JsonParser p) throws IOException {
            PrimitiveTokenOrExpectedObject result = new PrimitiveTokenOrExpectedObject();
            result.object = super.deserializeObject(p);
            return result;
        }

        @Override
        protected JsonDeserializer<?> getObjectDeserializer() throws IOException, JsonProcessingException {
            if (this.type != null && PrimitiveTokenOrExpectedObject.class.equals((Object)this.type.getRawClass())) {
                return this.ctxt.findRootValueDeserializer(this.type.containedType(0));
            }
            return super.getObjectDeserializer();
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            return super.createContextual(ctxt, property);
        }
    }
}

