/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.Map;
import org.apache.brooklyn.api.location.BasicMachineLocationCustomizer;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.file.BrooklynOsCommands;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.ssh.BashCommandsConfigurable;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetHostnameCustomizer
extends BasicMachineLocationCustomizer {
    public static final Logger log = LoggerFactory.getLogger(SetHostnameCustomizer.class);
    public static final ConfigKey<String> FIXED_HOSTNAME = ConfigKeys.newStringConfigKey((String)"hostname.fixed", (String)"The statically defined hostname to be set on the machine (if non-null)");
    public static final ConfigKey<String> FIXED_DOMAIN = ConfigKeys.newStringConfigKey((String)"domain.fixed", (String)"The statically defined domain name to be set on the machine (if non-null)");
    public static final ConfigKey<String> HOSTNAME_TEMPLATE = ConfigKeys.newStringConfigKey((String)"hostname.templated", (String)"The hostname template, to be resolved and then set on the machine (if non-null). Assumed to be in free-marker format.", (String)"ip-${((location.privateAddresses[0]??)?string(location.privateAddresses[0]!'X', (location.publicAddresses[0]??)?string(location.publicAddresses[0]!'X', \"none\")))?replace(\".\",\"-\")}-${location.id}");
    public static final ConfigKey<String> LOCAL_HOSTNAME = ConfigKeys.newStringConfigKey((String)"hostname.local.hostname", (String)"Host name, as known on the local box. Config is set on the location.");
    public static final ConfigKey<String> LOCAL_IP = ConfigKeys.newStringConfigKey((String)"hostname.local.address", (String)"Host address, as known on the local box. Config is set on the location.");
    public static final ConfigKey<Predicate<? super MachineLocation>> MACHINE_FILTER = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Predicate<? super MachineLocation>>(){}, (String)"machineFilter", (String)"A filter to say which machines this should be applied to", (Object)Predicates.instanceOf(SshMachineLocation.class));
    private final ConfigBag config;

    public SetHostnameCustomizer(ConfigBag config) {
        this.config = config;
    }

    public void customize(MachineLocation machine) {
        if (!((Predicate)this.config.get(MACHINE_FILTER)).apply((Object)machine)) {
            log.info("SetHostnameCustomizer ignoring non-ssh machine " + machine);
            return;
        }
        log.info("SetHostnameCustomizer setting hostname on " + machine);
        try {
            String localHostname = this.setLocalHostname((SshMachineLocation)machine);
            machine.config().set(LOCAL_HOSTNAME, (Object)localHostname);
            String localIp = this.execHostnameMinusI((SshMachineLocation)machine);
            machine.config().set(LOCAL_IP, (Object)localIp);
        }
        catch (Exception e) {
            log.info("SetHostnameCustomizer failed to set hostname on " + machine + " (rethrowing)", (Throwable)e);
            throw e;
        }
    }

    protected String generateHostname(SshMachineLocation machine) {
        String hostnameTemplate = (String)this.config.get(HOSTNAME_TEMPLATE);
        if (Strings.isNonBlank((CharSequence)hostnameTemplate)) {
            return TemplateProcessor.processTemplateContents((String)"hostname customizer template", (String)hostnameTemplate, (Location)machine, (Map)ImmutableMap.of());
        }
        return null;
    }

    public String setLocalHostname(SshMachineLocation machine) {
        String hostname;
        String hostFixed = (String)this.config.get(FIXED_HOSTNAME);
        String domainFixed = (String)this.config.get(FIXED_DOMAIN);
        String hostnameTemplate = (String)this.config.get(HOSTNAME_TEMPLATE);
        if (Strings.isNonBlank((CharSequence)hostFixed)) {
            hostname = hostFixed;
        } else if (Strings.isNonBlank((CharSequence)hostnameTemplate)) {
            hostname = this.generateHostname(machine);
        } else {
            hostname = this.execHostname(machine);
            if (Strings.isBlank((CharSequence)domainFixed)) {
                return hostname;
            }
        }
        return this.setLocalHostname(machine, hostname, domainFixed);
    }

    public String setLocalHostname(SshMachineLocation machine, String hostName, String domainFixed) {
        log.info("Setting local hostname of " + machine + " to " + hostName + (Strings.isNonBlank((CharSequence)domainFixed) ? ", " + domainFixed : ""));
        boolean hasDomain = Strings.isNonBlank((CharSequence)domainFixed);
        String fqdn = hasDomain ? hostName + "." + domainFixed : hostName;
        BashCommandsConfigurable bash = BrooklynOsCommands.bash((Location)machine);
        this.exec(machine, true, bash.sudo(String.format("sed -i.bak -e '1i127.0.0.1 %s %s' -e '/^127.0.0.1/d' /etc/hosts", fqdn, hostName)), bash.sudo(String.format("sed -i.bak -e 's/^HOSTNAME=.*$/HOSTNAME=%s/' /etc/sysconfig/network", fqdn)), bash.sudo(String.format("hostname %s", fqdn)));
        return hostName;
    }

    protected void registerEtcHosts(SshMachineLocation machine, String ip, Iterable<String> hostnames) {
        log.info("Updating /etc/hosts of " + machine + ": adding " + ip + " = " + hostnames);
        Preconditions.checkArgument((Strings.isNonBlank((CharSequence)ip) && Networking.isValidIp4((String)ip) ? 1 : 0) != 0, (String)"invalid IPv4 address %s", (Object)ip);
        if (Strings.isBlank((CharSequence)ip) || Iterables.isEmpty(hostnames)) {
            return;
        }
        String line = ip + " " + Joiner.on((String)" ").join(hostnames);
        this.exec(machine, true, "echo " + line + " >> /etc/hosts");
    }

    protected String execHostname(SshMachineLocation machine) {
        if (log.isDebugEnabled()) {
            log.debug("Retrieve `hostname` via ssh for {}", (Object)machine);
        }
        ProcessTaskWrapper<Integer> cmd = this.exec(machine, false, "echo hostname=`hostname`");
        for (String line : cmd.getStdout().split("\n")) {
            if (!line.contains("hostname=") || line.contains("`hostname`")) continue;
            return line.substring(line.indexOf("hostname=") + "hostname=".length()).trim();
        }
        log.info("No hostname found for {} (got {}; {})", new Object[]{machine, cmd.getStdout(), cmd.getStderr()});
        return null;
    }

    protected String execHostnameMinusI(SshMachineLocation machine) {
        if (log.isDebugEnabled()) {
            log.debug("Retrieve `hostname -I` via ssh for {}", (Object)machine);
        }
        ProcessTaskWrapper<Integer> cmd = this.exec(machine, false, "echo localip=`hostname -I`");
        for (String line : cmd.getStdout().split("\n")) {
            if (!line.contains("localip=") || line.contains("`hostname -I`")) continue;
            return line.substring(line.indexOf("localip=") + "localip=".length()).trim();
        }
        log.info("No local ip found for {} (got {}; {})", new Object[]{machine, cmd.getStdout(), cmd.getStderr()});
        return null;
    }

    protected ProcessTaskWrapper<Integer> exec(SshMachineLocation machine, boolean asRoot, String ... cmds) {
        ProcessTaskWrapper result;
        SshEffectorTasks.SshEffectorTaskFactory taskFactory = SshEffectorTasks.ssh((SshMachineLocation)machine, (String[])cmds);
        if (asRoot) {
            taskFactory.runAsRoot();
        }
        if ((Integer)(result = ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)taskFactory)).block()).get() != 0) {
            throw new IllegalStateException("SetHostnameCustomizer got exit code " + result.get() + " executing on machine " + machine + "; cmds=" + Arrays.asList(cmds) + "; stdout=" + result.getStdout() + "; stderr=" + result.getStderr());
        }
        return result;
    }
}

