/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.chef;

import com.google.common.base.Functions;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.feed.PollConfig;

public class ChefAttributePollConfig<T>
extends PollConfig<Object, T, ChefAttributePollConfig<T>> {
    private String chefAttributePath;

    public static <T> ChefAttributePollConfig<T> forSensor(AttributeSensor<T> sensor) {
        return new ChefAttributePollConfig<T>(sensor);
    }

    public static ChefAttributePollConfig<Void> forMultiple() {
        return new ChefAttributePollConfig<Void>(PollConfig.NO_SENSOR);
    }

    public ChefAttributePollConfig(AttributeSensor<T> sensor) {
        super(sensor);
        this.onSuccess(Functions.identity());
    }

    public ChefAttributePollConfig(ChefAttributePollConfig<T> other) {
        super(other);
        this.chefAttributePath = other.chefAttributePath;
    }

    public String getChefAttributePath() {
        return this.chefAttributePath;
    }

    public ChefAttributePollConfig<T> chefAttributePath(String val) {
        this.chefAttributePath = val;
        return this;
    }

    protected String toStringBaseName() {
        return "chef";
    }

    protected String toStringPollSource() {
        return this.chefAttributePath;
    }
}

