/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.failover;

import com.google.common.annotations.Beta;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.policy.failover.ElectPrimaryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class PrimaryRunningEnricher
extends AbstractEnricher
implements SensorEventListener<Object> {
    private static final Logger log = LoggerFactory.getLogger(PrimaryRunningEnricher.class);
    public static final ConfigKey<String> PRIMARY_SENSOR_NAME = ElectPrimaryConfig.PRIMARY_SENSOR_NAME;

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.subscriptions().subscribe((Entity)entity, (Sensor)Sensors.newSensor(Entity.class, (String)((String)this.config().get(PRIMARY_SENSOR_NAME))), (SensorEventListener)this);
        this.subscriptions().subscribeToChildren((Entity)entity, (Sensor)Attributes.SERVICE_UP, (SensorEventListener)this);
        this.subscriptions().subscribeToChildren((Entity)entity, (Sensor)Attributes.SERVICE_STATE_ACTUAL, (SensorEventListener)this);
        this.highlightTriggers("Listening for " + (String)this.config().get(PRIMARY_SENSOR_NAME) + " locally and service up and state at children");
        this.onEvent(null);
    }

    public void onEvent(SensorEvent<Object> event) {
        if (!Entities.isManagedActive((Entity)this.entity)) {
            return;
        }
        Entity primary = (Entity)this.entity.getAttribute(Sensors.newSensor(Entity.class, (String)((String)this.config().get(PRIMARY_SENSOR_NAME))));
        if (primary == null) {
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this.entity, (String)"primary.enricher", (Object)"no primary found");
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this.entity, (String)"primary.enricher", (Object)"no primary found");
        } else if (Lifecycle.RUNNING.equals(primary.getAttribute(Attributes.SERVICE_STATE_ACTUAL)) && Boolean.TRUE.equals(primary.getAttribute(Attributes.SERVICE_UP))) {
            if (ServiceStateLogic.getMapSensorEntry((Entity)this.entity, (AttributeSensor)Attributes.SERVICE_PROBLEMS, (Object)"primary.enricher") != null) {
                log.info("Primary " + primary + " at " + this.entity + " detected as healthy");
                ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((Entity)this.entity, (String)"primary.enricher");
                ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this.entity, (String)"primary.enricher");
            }
        } else {
            log.warn("Primary " + primary + " at " + this.entity + " detected as down or otherwise unhealthy");
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this.entity, (String)"primary.enricher", (Object)("Primary " + primary + " not in healthy state"));
        }
    }
}

