/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import com.google.common.base.Enums;

public enum Location {
    DE_FKB("de/fkb", "Germany, Karlsruhe"),
    DE_FRA("de/fra", "Germany, Frankfurt (M)"),
    US_LAS("us/las", "USA, Las Vegas"),
    US_LASDEV("us/lasdev", "USA Developer cluster"),
    UNRECOGNIZED("unrecognized", "Unrecognized location");

    private final String id;
    private final String description;

    private Location(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static Location fromValue(String v) {
        return (Location)((Object)Enums.getIfPresent(Location.class, (String)v).or((Object)UNRECOGNIZED));
    }

    public static Location fromId(String id) {
        for (Location location : Location.values()) {
            if (!location.id.equals(id)) continue;
            return location;
        }
        return UNRECOGNIZED;
    }

    public String toString() {
        return this.id;
    }
}

