// Licensed under the Apache License, Version 2.0 (the 'License'); you may not
// use this file except in compliance with the License. You may obtain a copy of
// the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an 'AS IS' BASIS, WITHOUT
// WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
// License for the specific language governing permissions and limitations under
// the License.

// Emoji mapping for various data processing and I/O operations
// Generate with AI
export const transformEmojiMap: Record<string, string> = {
  // Data processing operations
  AnomalyDetection: '🔍',
  AssertEqual: '⚖️',
  AssignTimestamps: '⏰',
  Combine: '🔄',
  Create: '✨',
  Enrichment: '💎',
  Explode: '💥',
  ExtractWindowingInfo: '🪟',
  Filter: '🔎',
  Flatten: '📉',
  Join: '🤝',
  LogForTesting: '📝',
  MLTransform: '🤖',
  MapToFields: '🗺️',
  Partition: '📂',
  PyTransform: '🐍',
  RunInference: '🧠',
  Sql: '🗃️',
  StripErrorMetadata: '🧹',
  ValidateWithSchema: '✅',
  WindowInto: '🪟',

  // I/O operations
  ReadFromAvro: '⬇️📁',
  WriteToAvro: '⬆️📁',
  ReadFromBigQuery: '⬇️📊',
  WriteToBigQuery: '⬆️📊',
  WriteToBigTable: '⬆️📋',
  ReadFromCsv: '⬇️📝',
  WriteToCsv: '⬆️📝',
  ReadFromIceberg: '⬇️🧊',
  WriteToIceberg: '⬆️🧊',
  ReadFromJdbc: '⬇️🔌',
  WriteToJdbc: '⬆️🔌',
  ReadFromJson: '⬇️📋',
  WriteToJson: '⬆️📋',
  ReadFromKafka: '⬇️📬',
  WriteToKafka: '⬆️📬',
  ReadFromMySql: '⬇️🐬',
  WriteToMySql: '⬆️🐬',
  ReadFromOracle: '⬇️🏛️',
  WriteToOracle: '⬆️🏛️',
  ReadFromParquet: '⬇️📦',
  WriteToParquet: '⬆️📦',
  ReadFromPostgres: '⬇️🐘',
  WriteToPostgres: '⬆️🐘',
  ReadFromPubSub: '⬇️📢',
  WriteToPubSub: '⬆️📢',
  ReadFromPubSubLite: '⬇️📣',
  WriteToPubSubLite: '⬆️📣',
  ReadFromSpanner: '⬇️📏',
  WriteToSpanner: '⬆️📏',
  ReadFromSqlServer: '⬇️🗄️',
  WriteToSqlServer: '⬆️🗄️',
  ReadFromTFRecord: '⬇️📼',
  WriteToTFRecord: '⬆️📼',
  ReadFromText: '⬇️📄',
  WriteToText: '⬆️📄'
};
