/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class JavacExternal
extends DefaultCompilerAdapter {
    @Override
    public boolean execute() throws BuildException {
        this.attributes.log("Using external javac compiler", 3);
        Commandline cmd = new Commandline();
        cmd.setExecutable(this.getJavac().getJavacExecutable());
        if (this.assumeJava1_3Plus()) {
            this.setupModernJavacCommandlineSwitches(cmd);
        } else {
            this.setupJavacCommandlineSwitches(cmd, true);
        }
        int openVmsFirstFileName = this.assumeJava1_2Plus() ? cmd.size() : -1;
        this.logAndAddFilesToCompile(cmd);
        if (Os.isFamily("openvms")) {
            return this.execOnVMS(cmd, openVmsFirstFileName);
        }
        String[] commandLine = cmd.getCommandline();
        int firstFileName = this.assumeJava1_2Plus() ? this.moveArgFileEligibleOptionsToEnd(commandLine) : -1;
        return this.executeExternalCompile(commandLine, firstFileName, true) == 0;
    }

    private int moveArgFileEligibleOptionsToEnd(String[] commandLine) {
        int nonArgFileOptionIdx;
        for (nonArgFileOptionIdx = 1; nonArgFileOptionIdx < commandLine.length && !JavacExternal.isArgFileEligible(commandLine[nonArgFileOptionIdx]); ++nonArgFileOptionIdx) {
        }
        for (int i = nonArgFileOptionIdx + 1; i < commandLine.length; ++i) {
            if (JavacExternal.isArgFileEligible(commandLine[i])) continue;
            String option = commandLine[i];
            for (int j = i - 1; j >= nonArgFileOptionIdx; --j) {
                commandLine[j + 1] = commandLine[j];
            }
            commandLine[nonArgFileOptionIdx] = option;
            ++nonArgFileOptionIdx;
        }
        return nonArgFileOptionIdx;
    }

    private static boolean isArgFileEligible(String option) {
        return !option.startsWith("-J") && !option.startsWith("@");
    }

    private boolean execOnVMS(Commandline cmd, int firstFileName) {
        File vmsFile = null;
        try {
            vmsFile = JavaEnvUtils.createVmsJavaOptionFile(cmd.getArguments());
            String[] commandLine = new String[]{cmd.getExecutable(), "-V", vmsFile.getPath()};
            boolean bl = 0 == this.executeExternalCompile(commandLine, firstFileName, true);
            return bl;
        }
        catch (IOException e) {
            throw new BuildException("Failed to create a temporary file for \"-V\" switch");
        }
        finally {
            FileUtils.delete(vmsFile);
        }
    }
}

