/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.EtagSource;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.statistics.IOStatisticsAggregator;
import org.apache.hadoop.fs.statistics.IOStatisticsSetters;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStoreBuilder;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterConstants;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.InternalConstants;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperationsThroughFileSystem;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public final class ManifestCommitterSupport {
    private ManifestCommitterSupport() {
    }

    public static IOStatisticsStoreBuilder createIOStatisticsStore() {
        IOStatisticsStoreBuilder store = IOStatisticsBinding.iostatisticsStore();
        store.withSampleTracking(InternalConstants.COUNTER_STATISTICS);
        store.withDurationTracking(InternalConstants.DURATION_STATISTICS);
        return store;
    }

    public static void maybeAddIOStatistics(IOStatisticsAggregator ios, Object o) {
        if (o instanceof IOStatisticsSource) {
            ios.aggregate(((IOStatisticsSource)o).getIOStatistics());
        }
    }

    public static Pair<String, String> buildJobUUID(Configuration conf, JobID jobId) {
        String jobUUID = conf.getTrimmed("spark.sql.sources.writeJobUUID", "");
        if (jobUUID.isEmpty()) {
            jobUUID = jobId.toString();
            return Pair.of(jobUUID, "JobID");
        }
        return Pair.of(jobUUID, "spark.sql.sources.writeJobUUID");
    }

    public static Path getPendingJobAttemptsPath(Path out) {
        return new Path(out, "_temporary");
    }

    public static int getAppAttemptId(JobContext context) {
        return ManifestCommitterSupport.getAppAttemptId(context.getConfiguration());
    }

    public static int getAppAttemptId(Configuration conf) {
        return conf.getInt("mapreduce.job.application.attempt.id", 0);
    }

    public static Path manifestPathForTask(Path manifestDir, String taskId) {
        return new Path(manifestDir, taskId + "-manifest.json");
    }

    public static Path manifestTempPathForTaskAttempt(Path manifestDir, String taskAttemptId) {
        return new Path(manifestDir, taskAttemptId + "-manifest.json" + ".tmp");
    }

    public static TaskManifest createTaskManifest(StageConfig stageConfig) {
        TaskManifest manifest = new TaskManifest();
        manifest.setTaskAttemptID(stageConfig.getTaskAttemptId());
        manifest.setTaskID(stageConfig.getTaskId());
        manifest.setJobId(stageConfig.getJobId());
        manifest.setJobAttemptNumber(stageConfig.getJobAttemptNumber());
        manifest.setTaskAttemptDir(stageConfig.getTaskAttemptDir().toUri().toString());
        return manifest;
    }

    public static ManifestSuccessData createManifestOutcome(StageConfig stageConfig, String stage) {
        ManifestSuccessData outcome = new ManifestSuccessData();
        outcome.setJobId(stageConfig.getJobId());
        outcome.setJobIdSource(stageConfig.getJobIdSource());
        outcome.setCommitter(ManifestCommitterConstants.MANIFEST_COMMITTER_CLASSNAME);
        outcome.setTimestamp(System.currentTimeMillis());
        ZonedDateTime now = ZonedDateTime.now();
        outcome.setDate(now.toString());
        outcome.setHostname(NetUtils.getLocalHostname());
        try {
            outcome.putDiagnostic("principal", UserGroupInformation.getCurrentUser().getShortUserName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        outcome.putDiagnostic("stage", stage);
        return outcome;
    }

    public static void addHeapInformation(IOStatisticsSetters ioStatisticsSetters, String stage) {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        String prefix = "stage.";
        ioStatisticsSetters.setGauge("stage." + stage + "." + "total.memory", totalMemory);
        ioStatisticsSetters.setGauge("stage." + stage + "." + "free.memory", freeMemory);
        ioStatisticsSetters.setGauge("stage." + stage + "." + "heap.memory", totalMemory - freeMemory);
    }

    public static String createJobSummaryFilename(String jobId) {
        return String.format("summary-%s.json", jobId);
    }

    public static String getEtag(FileStatus status) {
        if (status instanceof EtagSource) {
            return ((EtagSource)((Object)status)).getEtag();
        }
        return null;
    }

    public static ManifestStoreOperations createManifestStoreOperations(Configuration conf, FileSystem filesystem, Path path) throws IOException {
        try {
            Class<ManifestStoreOperations> storeClass = conf.getClass("mapreduce.manifest.committer.store.operations.classname", ManifestStoreOperationsThroughFileSystem.class, ManifestStoreOperations.class);
            ManifestStoreOperations operations = storeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            operations.bindToFileSystem(filesystem, path);
            return operations;
        }
        catch (Exception e) {
            throw new PathIOException(path.toString(), "Failed to create Store Operations from configuration option mapreduce.manifest.committer.store.operations.classname:" + e, e);
        }
    }

    public static class AttemptDirectories {
        private final Path outputPath;
        private final Path jobAttemptDir;
        private final Path jobPath;
        private final Path jobAttemptTaskSubDir;
        private final Path outputTempSubDir;
        private final Path taskManifestDir;

        public AttemptDirectories(Path outputPath, String jobUniqueId, int jobAttemptNumber) {
            this.outputPath = Objects.requireNonNull(outputPath, "Output path");
            this.outputTempSubDir = new Path(outputPath, "_temporary");
            this.jobPath = new Path(this.outputTempSubDir, String.format("%s", jobUniqueId));
            this.jobAttemptDir = new Path(this.jobPath, String.format("%02d", jobAttemptNumber));
            this.jobAttemptTaskSubDir = new Path(this.jobAttemptDir, "tasks");
            this.taskManifestDir = new Path(this.jobAttemptDir, "manifests");
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public Path getJobAttemptDir() {
            return this.jobAttemptDir;
        }

        public Path getJobPath() {
            return this.jobPath;
        }

        public Path getJobAttemptTaskSubDir() {
            return this.jobAttemptTaskSubDir;
        }

        public Path getTaskAttemptPath(String taskAttemptId) {
            return new Path(this.jobAttemptTaskSubDir, taskAttemptId);
        }

        public Path getOutputTempSubDir() {
            return this.outputTempSubDir;
        }

        public Path getTaskManifestDir() {
            return this.taskManifestDir;
        }
    }
}

