/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security.xacml;

import java.rmi.RemoteException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.identity.entitlement.stub.EntitlementPolicyAdminServiceEntitlementException;
import org.wso2.carbon.identity.entitlement.stub.EntitlementPolicyAdminServiceStub;
import org.wso2.carbon.identity.entitlement.stub.dto.PaginatedStatusHolder;
import org.wso2.carbon.identity.entitlement.stub.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.stub.dto.StatusHolder;
import org.wso2.carbon.utils.CarbonUtils;

public class DefaultPAPClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPAPClient.class);
    private EntitlementPolicyAdminServiceStub entitlementPolicyAdminServiceStub;

    public DefaultPAPClient(String auhorizationServerURL, String username, String password, ConfigurationContext configCtx) throws AiravataSecurityException {
        try {
            String PDPURL = auhorizationServerURL + "EntitlementPolicyAdminService";
            this.entitlementPolicyAdminServiceStub = new EntitlementPolicyAdminServiceStub(configCtx, PDPURL);
            CarbonUtils.setBasicAccessSecurityHeaders((String)username, (String)password, (boolean)true, (ServiceClient)this.entitlementPolicyAdminServiceStub._getServiceClient());
        }
        catch (AxisFault e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error initializing XACML PEP client.");
        }
    }

    public boolean isPolicyAdded(String policyName) {
        try {
            PolicyDTO policyDTO = this.entitlementPolicyAdminServiceStub.getPolicy(policyName, false);
        }
        catch (RemoteException e) {
            logger.debug("Error in retrieving the policy.", (Throwable)e);
            return false;
        }
        catch (EntitlementPolicyAdminServiceEntitlementException e) {
            logger.debug("Error in retrieving the policy.", (Throwable)e);
            return false;
        }
        return true;
    }

    public void addPolicy(final String policy) throws AiravataSecurityException {
        new Thread(){

            @Override
            public void run() {
                try {
                    PolicyDTO policyDTO = new PolicyDTO();
                    policyDTO.setPolicy(policy);
                    DefaultPAPClient.this.entitlementPolicyAdminServiceStub.addPolicy(policyDTO);
                    DefaultPAPClient.this.entitlementPolicyAdminServiceStub.publishToPDP(new String[]{ServerSettings.getAuthorizationPoliyName()}, "CREATE", null, false, 0);
                    Thread.sleep(2000L);
                    PaginatedStatusHolder paginatedStatusHolder = DefaultPAPClient.this.entitlementPolicyAdminServiceStub.getStatusData("POLICY", ServerSettings.getAuthorizationPoliyName(), "PUBLISH_POLICY", "*", 1);
                    StatusHolder statusHolder = paginatedStatusHolder.getStatusHolders()[0];
                    if (!statusHolder.getSuccess() || !"CREATE".equals(statusHolder.getTargetAction())) {
                        throw new AiravataSecurityException("Failed to publish the authorization policy.");
                    }
                    logger.info("Authorization policy is published successfully.");
                    DefaultPAPClient.this.entitlementPolicyAdminServiceStub.enableDisablePolicy(ServerSettings.getAuthorizationPoliyName(), true);
                    Thread.sleep(2000L);
                    paginatedStatusHolder = DefaultPAPClient.this.entitlementPolicyAdminServiceStub.getStatusData("POLICY", ServerSettings.getAuthorizationPoliyName(), "PUBLISH_POLICY", "*", 1);
                    statusHolder = paginatedStatusHolder.getStatusHolders()[0];
                    if (!statusHolder.getSuccess() || !"ENABLE".equals(statusHolder.getTargetAction())) {
                        throw new AiravataSecurityException("Failed to enable the authorization policy.");
                    }
                    logger.info("Authorization policy is enabled successfully.");
                }
                catch (RemoteException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (ApplicationSettingsException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (AiravataSecurityException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (EntitlementPolicyAdminServiceEntitlementException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }.start();
    }
}

