/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.task;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TaskModel
implements TBase<TaskModel, _Fields>,
Serializable,
Cloneable,
Comparable<TaskModel> {
    private static final TStruct STRUCT_DESC = new TStruct("TaskModel");
    private static final TField TASK_ID_FIELD_DESC = new TField("taskId", 11, 1);
    private static final TField TASK_TYPE_FIELD_DESC = new TField("taskType", 8, 2);
    private static final TField PARENT_PROCESS_ID_FIELD_DESC = new TField("parentProcessId", 11, 3);
    private static final TField CREATION_TIME_FIELD_DESC = new TField("creationTime", 10, 4);
    private static final TField LAST_UPDATE_TIME_FIELD_DESC = new TField("lastUpdateTime", 10, 5);
    private static final TField TASK_STATUSES_FIELD_DESC = new TField("taskStatuses", 15, 6);
    private static final TField TASK_DETAIL_FIELD_DESC = new TField("taskDetail", 11, 7);
    private static final TField SUB_TASK_MODEL_FIELD_DESC = new TField("subTaskModel", 11, 8);
    private static final TField TASK_ERRORS_FIELD_DESC = new TField("taskErrors", 15, 9);
    private static final TField JOBS_FIELD_DESC = new TField("jobs", 15, 10);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String taskId;
    private TaskTypes taskType;
    private String parentProcessId;
    private long creationTime;
    private long lastUpdateTime;
    private List<TaskStatus> taskStatuses;
    private String taskDetail;
    private ByteBuffer subTaskModel;
    private List<ErrorModel> taskErrors;
    private List<JobModel> jobs;
    private static final int __CREATIONTIME_ISSET_ID = 0;
    private static final int __LASTUPDATETIME_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TaskModel() {
        this.taskId = "DO_NOT_SET_AT_CLIENTS";
    }

    public TaskModel(String taskId, TaskTypes taskType, String parentProcessId, long creationTime, long lastUpdateTime, List<TaskStatus> taskStatuses) {
        this();
        this.taskId = taskId;
        this.taskType = taskType;
        this.parentProcessId = parentProcessId;
        this.creationTime = creationTime;
        this.setCreationTimeIsSet(true);
        this.lastUpdateTime = lastUpdateTime;
        this.setLastUpdateTimeIsSet(true);
        this.taskStatuses = taskStatuses;
    }

    public TaskModel(TaskModel other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetTaskId()) {
            this.taskId = other.taskId;
        }
        if (other.isSetTaskType()) {
            this.taskType = other.taskType;
        }
        if (other.isSetParentProcessId()) {
            this.parentProcessId = other.parentProcessId;
        }
        this.creationTime = other.creationTime;
        this.lastUpdateTime = other.lastUpdateTime;
        if (other.isSetTaskStatuses()) {
            ArrayList<TaskStatus> __this__taskStatuses = new ArrayList<TaskStatus>(other.taskStatuses.size());
            for (TaskStatus taskStatus : other.taskStatuses) {
                __this__taskStatuses.add(new TaskStatus(taskStatus));
            }
            this.taskStatuses = __this__taskStatuses;
        }
        if (other.isSetTaskDetail()) {
            this.taskDetail = other.taskDetail;
        }
        if (other.isSetSubTaskModel()) {
            this.subTaskModel = TBaseHelper.copyBinary((ByteBuffer)other.subTaskModel);
        }
        if (other.isSetTaskErrors()) {
            ArrayList<ErrorModel> __this__taskErrors = new ArrayList<ErrorModel>(other.taskErrors.size());
            for (ErrorModel errorModel : other.taskErrors) {
                __this__taskErrors.add(new ErrorModel(errorModel));
            }
            this.taskErrors = __this__taskErrors;
        }
        if (other.isSetJobs()) {
            ArrayList<JobModel> __this__jobs = new ArrayList<JobModel>(other.jobs.size());
            for (JobModel jobModel : other.jobs) {
                __this__jobs.add(new JobModel(jobModel));
            }
            this.jobs = __this__jobs;
        }
    }

    public TaskModel deepCopy() {
        return new TaskModel(this);
    }

    public void clear() {
        this.taskId = "DO_NOT_SET_AT_CLIENTS";
        this.taskType = null;
        this.parentProcessId = null;
        this.setCreationTimeIsSet(false);
        this.creationTime = 0L;
        this.setLastUpdateTimeIsSet(false);
        this.lastUpdateTime = 0L;
        this.taskStatuses = null;
        this.taskDetail = null;
        this.subTaskModel = null;
        this.taskErrors = null;
        this.jobs = null;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void unsetTaskId() {
        this.taskId = null;
    }

    public boolean isSetTaskId() {
        return this.taskId != null;
    }

    public void setTaskIdIsSet(boolean value) {
        if (!value) {
            this.taskId = null;
        }
    }

    public TaskTypes getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskTypes taskType) {
        this.taskType = taskType;
    }

    public void unsetTaskType() {
        this.taskType = null;
    }

    public boolean isSetTaskType() {
        return this.taskType != null;
    }

    public void setTaskTypeIsSet(boolean value) {
        if (!value) {
            this.taskType = null;
        }
    }

    public String getParentProcessId() {
        return this.parentProcessId;
    }

    public void setParentProcessId(String parentProcessId) {
        this.parentProcessId = parentProcessId;
    }

    public void unsetParentProcessId() {
        this.parentProcessId = null;
    }

    public boolean isSetParentProcessId() {
        return this.parentProcessId != null;
    }

    public void setParentProcessIdIsSet(boolean value) {
        if (!value) {
            this.parentProcessId = null;
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        this.setCreationTimeIsSet(true);
    }

    public void unsetCreationTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetCreationTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setCreationTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        this.setLastUpdateTimeIsSet(true);
    }

    public void unsetLastUpdateTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetLastUpdateTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setLastUpdateTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getTaskStatusesSize() {
        return this.taskStatuses == null ? 0 : this.taskStatuses.size();
    }

    public Iterator<TaskStatus> getTaskStatusesIterator() {
        return this.taskStatuses == null ? null : this.taskStatuses.iterator();
    }

    public void addToTaskStatuses(TaskStatus elem) {
        if (this.taskStatuses == null) {
            this.taskStatuses = new ArrayList<TaskStatus>();
        }
        this.taskStatuses.add(elem);
    }

    public List<TaskStatus> getTaskStatuses() {
        return this.taskStatuses;
    }

    public void setTaskStatuses(List<TaskStatus> taskStatuses) {
        this.taskStatuses = taskStatuses;
    }

    public void unsetTaskStatuses() {
        this.taskStatuses = null;
    }

    public boolean isSetTaskStatuses() {
        return this.taskStatuses != null;
    }

    public void setTaskStatusesIsSet(boolean value) {
        if (!value) {
            this.taskStatuses = null;
        }
    }

    public String getTaskDetail() {
        return this.taskDetail;
    }

    public void setTaskDetail(String taskDetail) {
        this.taskDetail = taskDetail;
    }

    public void unsetTaskDetail() {
        this.taskDetail = null;
    }

    public boolean isSetTaskDetail() {
        return this.taskDetail != null;
    }

    public void setTaskDetailIsSet(boolean value) {
        if (!value) {
            this.taskDetail = null;
        }
    }

    public byte[] getSubTaskModel() {
        this.setSubTaskModel(TBaseHelper.rightSize((ByteBuffer)this.subTaskModel));
        return this.subTaskModel == null ? null : this.subTaskModel.array();
    }

    public ByteBuffer bufferForSubTaskModel() {
        return TBaseHelper.copyBinary((ByteBuffer)this.subTaskModel);
    }

    public void setSubTaskModel(byte[] subTaskModel) {
        this.subTaskModel = subTaskModel == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(subTaskModel, subTaskModel.length));
    }

    public void setSubTaskModel(ByteBuffer subTaskModel) {
        this.subTaskModel = TBaseHelper.copyBinary((ByteBuffer)subTaskModel);
    }

    public void unsetSubTaskModel() {
        this.subTaskModel = null;
    }

    public boolean isSetSubTaskModel() {
        return this.subTaskModel != null;
    }

    public void setSubTaskModelIsSet(boolean value) {
        if (!value) {
            this.subTaskModel = null;
        }
    }

    public int getTaskErrorsSize() {
        return this.taskErrors == null ? 0 : this.taskErrors.size();
    }

    public Iterator<ErrorModel> getTaskErrorsIterator() {
        return this.taskErrors == null ? null : this.taskErrors.iterator();
    }

    public void addToTaskErrors(ErrorModel elem) {
        if (this.taskErrors == null) {
            this.taskErrors = new ArrayList<ErrorModel>();
        }
        this.taskErrors.add(elem);
    }

    public List<ErrorModel> getTaskErrors() {
        return this.taskErrors;
    }

    public void setTaskErrors(List<ErrorModel> taskErrors) {
        this.taskErrors = taskErrors;
    }

    public void unsetTaskErrors() {
        this.taskErrors = null;
    }

    public boolean isSetTaskErrors() {
        return this.taskErrors != null;
    }

    public void setTaskErrorsIsSet(boolean value) {
        if (!value) {
            this.taskErrors = null;
        }
    }

    public int getJobsSize() {
        return this.jobs == null ? 0 : this.jobs.size();
    }

    public Iterator<JobModel> getJobsIterator() {
        return this.jobs == null ? null : this.jobs.iterator();
    }

    public void addToJobs(JobModel elem) {
        if (this.jobs == null) {
            this.jobs = new ArrayList<JobModel>();
        }
        this.jobs.add(elem);
    }

    public List<JobModel> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<JobModel> jobs) {
        this.jobs = jobs;
    }

    public void unsetJobs() {
        this.jobs = null;
    }

    public boolean isSetJobs() {
        return this.jobs != null;
    }

    public void setJobsIsSet(boolean value) {
        if (!value) {
            this.jobs = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TASK_ID: {
                if (value == null) {
                    this.unsetTaskId();
                    break;
                }
                this.setTaskId((String)value);
                break;
            }
            case TASK_TYPE: {
                if (value == null) {
                    this.unsetTaskType();
                    break;
                }
                this.setTaskType((TaskTypes)((Object)value));
                break;
            }
            case PARENT_PROCESS_ID: {
                if (value == null) {
                    this.unsetParentProcessId();
                    break;
                }
                this.setParentProcessId((String)value);
                break;
            }
            case CREATION_TIME: {
                if (value == null) {
                    this.unsetCreationTime();
                    break;
                }
                this.setCreationTime((Long)value);
                break;
            }
            case LAST_UPDATE_TIME: {
                if (value == null) {
                    this.unsetLastUpdateTime();
                    break;
                }
                this.setLastUpdateTime((Long)value);
                break;
            }
            case TASK_STATUSES: {
                if (value == null) {
                    this.unsetTaskStatuses();
                    break;
                }
                this.setTaskStatuses((List)value);
                break;
            }
            case TASK_DETAIL: {
                if (value == null) {
                    this.unsetTaskDetail();
                    break;
                }
                this.setTaskDetail((String)value);
                break;
            }
            case SUB_TASK_MODEL: {
                if (value == null) {
                    this.unsetSubTaskModel();
                    break;
                }
                this.setSubTaskModel((ByteBuffer)value);
                break;
            }
            case TASK_ERRORS: {
                if (value == null) {
                    this.unsetTaskErrors();
                    break;
                }
                this.setTaskErrors((List)value);
                break;
            }
            case JOBS: {
                if (value == null) {
                    this.unsetJobs();
                    break;
                }
                this.setJobs((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TASK_ID: {
                return this.getTaskId();
            }
            case TASK_TYPE: {
                return this.getTaskType();
            }
            case PARENT_PROCESS_ID: {
                return this.getParentProcessId();
            }
            case CREATION_TIME: {
                return this.getCreationTime();
            }
            case LAST_UPDATE_TIME: {
                return this.getLastUpdateTime();
            }
            case TASK_STATUSES: {
                return this.getTaskStatuses();
            }
            case TASK_DETAIL: {
                return this.getTaskDetail();
            }
            case SUB_TASK_MODEL: {
                return this.getSubTaskModel();
            }
            case TASK_ERRORS: {
                return this.getTaskErrors();
            }
            case JOBS: {
                return this.getJobs();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TASK_ID: {
                return this.isSetTaskId();
            }
            case TASK_TYPE: {
                return this.isSetTaskType();
            }
            case PARENT_PROCESS_ID: {
                return this.isSetParentProcessId();
            }
            case CREATION_TIME: {
                return this.isSetCreationTime();
            }
            case LAST_UPDATE_TIME: {
                return this.isSetLastUpdateTime();
            }
            case TASK_STATUSES: {
                return this.isSetTaskStatuses();
            }
            case TASK_DETAIL: {
                return this.isSetTaskDetail();
            }
            case SUB_TASK_MODEL: {
                return this.isSetSubTaskModel();
            }
            case TASK_ERRORS: {
                return this.isSetTaskErrors();
            }
            case JOBS: {
                return this.isSetJobs();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TaskModel) {
            return this.equals((TaskModel)that);
        }
        return false;
    }

    public boolean equals(TaskModel that) {
        if (that == null) {
            return false;
        }
        boolean this_present_taskId = this.isSetTaskId();
        boolean that_present_taskId = that.isSetTaskId();
        if (this_present_taskId || that_present_taskId) {
            if (!this_present_taskId || !that_present_taskId) {
                return false;
            }
            if (!this.taskId.equals(that.taskId)) {
                return false;
            }
        }
        boolean this_present_taskType = this.isSetTaskType();
        boolean that_present_taskType = that.isSetTaskType();
        if (this_present_taskType || that_present_taskType) {
            if (!this_present_taskType || !that_present_taskType) {
                return false;
            }
            if (!this.taskType.equals((Object)that.taskType)) {
                return false;
            }
        }
        boolean this_present_parentProcessId = this.isSetParentProcessId();
        boolean that_present_parentProcessId = that.isSetParentProcessId();
        if (this_present_parentProcessId || that_present_parentProcessId) {
            if (!this_present_parentProcessId || !that_present_parentProcessId) {
                return false;
            }
            if (!this.parentProcessId.equals(that.parentProcessId)) {
                return false;
            }
        }
        boolean this_present_creationTime = true;
        boolean that_present_creationTime = true;
        if (this_present_creationTime || that_present_creationTime) {
            if (!this_present_creationTime || !that_present_creationTime) {
                return false;
            }
            if (this.creationTime != that.creationTime) {
                return false;
            }
        }
        boolean this_present_lastUpdateTime = true;
        boolean that_present_lastUpdateTime = true;
        if (this_present_lastUpdateTime || that_present_lastUpdateTime) {
            if (!this_present_lastUpdateTime || !that_present_lastUpdateTime) {
                return false;
            }
            if (this.lastUpdateTime != that.lastUpdateTime) {
                return false;
            }
        }
        boolean this_present_taskStatuses = this.isSetTaskStatuses();
        boolean that_present_taskStatuses = that.isSetTaskStatuses();
        if (this_present_taskStatuses || that_present_taskStatuses) {
            if (!this_present_taskStatuses || !that_present_taskStatuses) {
                return false;
            }
            if (!this.taskStatuses.equals(that.taskStatuses)) {
                return false;
            }
        }
        boolean this_present_taskDetail = this.isSetTaskDetail();
        boolean that_present_taskDetail = that.isSetTaskDetail();
        if (this_present_taskDetail || that_present_taskDetail) {
            if (!this_present_taskDetail || !that_present_taskDetail) {
                return false;
            }
            if (!this.taskDetail.equals(that.taskDetail)) {
                return false;
            }
        }
        boolean this_present_subTaskModel = this.isSetSubTaskModel();
        boolean that_present_subTaskModel = that.isSetSubTaskModel();
        if (this_present_subTaskModel || that_present_subTaskModel) {
            if (!this_present_subTaskModel || !that_present_subTaskModel) {
                return false;
            }
            if (!this.subTaskModel.equals(that.subTaskModel)) {
                return false;
            }
        }
        boolean this_present_taskErrors = this.isSetTaskErrors();
        boolean that_present_taskErrors = that.isSetTaskErrors();
        if (this_present_taskErrors || that_present_taskErrors) {
            if (!this_present_taskErrors || !that_present_taskErrors) {
                return false;
            }
            if (!this.taskErrors.equals(that.taskErrors)) {
                return false;
            }
        }
        boolean this_present_jobs = this.isSetJobs();
        boolean that_present_jobs = that.isSetJobs();
        if (this_present_jobs || that_present_jobs) {
            if (!this_present_jobs || !that_present_jobs) {
                return false;
            }
            if (!this.jobs.equals(that.jobs)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_taskId = this.isSetTaskId();
        list.add(present_taskId);
        if (present_taskId) {
            list.add(this.taskId);
        }
        boolean present_taskType = this.isSetTaskType();
        list.add(present_taskType);
        if (present_taskType) {
            list.add(this.taskType.getValue());
        }
        boolean present_parentProcessId = this.isSetParentProcessId();
        list.add(present_parentProcessId);
        if (present_parentProcessId) {
            list.add(this.parentProcessId);
        }
        boolean present_creationTime = true;
        list.add(present_creationTime);
        if (present_creationTime) {
            list.add(this.creationTime);
        }
        boolean present_lastUpdateTime = true;
        list.add(present_lastUpdateTime);
        if (present_lastUpdateTime) {
            list.add(this.lastUpdateTime);
        }
        boolean present_taskStatuses = this.isSetTaskStatuses();
        list.add(present_taskStatuses);
        if (present_taskStatuses) {
            list.add(this.taskStatuses);
        }
        boolean present_taskDetail = this.isSetTaskDetail();
        list.add(present_taskDetail);
        if (present_taskDetail) {
            list.add(this.taskDetail);
        }
        boolean present_subTaskModel = this.isSetSubTaskModel();
        list.add(present_subTaskModel);
        if (present_subTaskModel) {
            list.add(this.subTaskModel);
        }
        boolean present_taskErrors = this.isSetTaskErrors();
        list.add(present_taskErrors);
        if (present_taskErrors) {
            list.add(this.taskErrors);
        }
        boolean present_jobs = this.isSetJobs();
        list.add(present_jobs);
        if (present_jobs) {
            list.add(this.jobs);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(TaskModel other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetTaskId()).compareTo(other.isSetTaskId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskId() && (lastComparison = TBaseHelper.compareTo((String)this.taskId, (String)other.taskId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskType()).compareTo(other.isSetTaskType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.taskType), (Comparable)((Object)other.taskType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParentProcessId()).compareTo(other.isSetParentProcessId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParentProcessId() && (lastComparison = TBaseHelper.compareTo((String)this.parentProcessId, (String)other.parentProcessId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreationTime()).compareTo(other.isSetCreationTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreationTime() && (lastComparison = TBaseHelper.compareTo((long)this.creationTime, (long)other.creationTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLastUpdateTime()).compareTo(other.isSetLastUpdateTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLastUpdateTime() && (lastComparison = TBaseHelper.compareTo((long)this.lastUpdateTime, (long)other.lastUpdateTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskStatuses()).compareTo(other.isSetTaskStatuses());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskStatuses() && (lastComparison = TBaseHelper.compareTo(this.taskStatuses, other.taskStatuses)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskDetail()).compareTo(other.isSetTaskDetail());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskDetail() && (lastComparison = TBaseHelper.compareTo((String)this.taskDetail, (String)other.taskDetail)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSubTaskModel()).compareTo(other.isSetSubTaskModel());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSubTaskModel() && (lastComparison = TBaseHelper.compareTo((Comparable)this.subTaskModel, (Comparable)other.subTaskModel)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskErrors()).compareTo(other.isSetTaskErrors());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskErrors() && (lastComparison = TBaseHelper.compareTo(this.taskErrors, other.taskErrors)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetJobs()).compareTo(other.isSetJobs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJobs() && (lastComparison = TBaseHelper.compareTo(this.jobs, other.jobs)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TaskModel(");
        boolean first = true;
        sb.append("taskId:");
        if (this.taskId == null) {
            sb.append("null");
        } else {
            sb.append(this.taskId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("taskType:");
        if (this.taskType == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.taskType);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parentProcessId:");
        if (this.parentProcessId == null) {
            sb.append("null");
        } else {
            sb.append(this.parentProcessId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("creationTime:");
        sb.append(this.creationTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("lastUpdateTime:");
        sb.append(this.lastUpdateTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("taskStatuses:");
        if (this.taskStatuses == null) {
            sb.append("null");
        } else {
            sb.append(this.taskStatuses);
        }
        first = false;
        if (this.isSetTaskDetail()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("taskDetail:");
            if (this.taskDetail == null) {
                sb.append("null");
            } else {
                sb.append(this.taskDetail);
            }
            first = false;
        }
        if (this.isSetSubTaskModel()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("subTaskModel:");
            if (this.subTaskModel == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.subTaskModel, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetTaskErrors()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("taskErrors:");
            if (this.taskErrors == null) {
                sb.append("null");
            } else {
                sb.append(this.taskErrors);
            }
            first = false;
        }
        if (this.isSetJobs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("jobs:");
            if (this.jobs == null) {
                sb.append("null");
            } else {
                sb.append(this.jobs);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetTaskId()) {
            throw new TProtocolException("Required field 'taskId' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTaskType()) {
            throw new TProtocolException("Required field 'taskType' is unset! Struct:" + this.toString());
        }
        if (!this.isSetParentProcessId()) {
            throw new TProtocolException("Required field 'parentProcessId' is unset! Struct:" + this.toString());
        }
        if (!this.isSetCreationTime()) {
            throw new TProtocolException("Required field 'creationTime' is unset! Struct:" + this.toString());
        }
        if (!this.isSetLastUpdateTime()) {
            throw new TProtocolException("Required field 'lastUpdateTime' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTaskStatuses()) {
            throw new TProtocolException("Required field 'taskStatuses' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TaskModelStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TaskModelTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.TASK_DETAIL, _Fields.SUB_TASK_MODEL, _Fields.TASK_ERRORS, _Fields.JOBS};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TASK_ID, new FieldMetaData("taskId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TASK_TYPE, new FieldMetaData("taskType", 1, (FieldValueMetaData)new EnumMetaData(16, TaskTypes.class)));
        tmpMap.put(_Fields.PARENT_PROCESS_ID, new FieldMetaData("parentProcessId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CREATION_TIME, new FieldMetaData("creationTime", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.LAST_UPDATE_TIME, new FieldMetaData("lastUpdateTime", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TASK_STATUSES, new FieldMetaData("taskStatuses", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TaskStatus.class))));
        tmpMap.put(_Fields.TASK_DETAIL, new FieldMetaData("taskDetail", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SUB_TASK_MODEL, new FieldMetaData("subTaskModel", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.TASK_ERRORS, new FieldMetaData("taskErrors", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ErrorModel.class))));
        tmpMap.put(_Fields.JOBS, new FieldMetaData("jobs", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, JobModel.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TaskModel.class, metaDataMap);
    }

    private static class TaskModelTupleScheme
    extends TupleScheme<TaskModel> {
        private TaskModelTupleScheme() {
        }

        public void write(TProtocol prot, TaskModel struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.taskId);
            oprot.writeI32(struct.taskType.getValue());
            oprot.writeString(struct.parentProcessId);
            oprot.writeI64(struct.creationTime);
            oprot.writeI64(struct.lastUpdateTime);
            oprot.writeI32(struct.taskStatuses.size());
            for (TaskStatus _iter12 : struct.taskStatuses) {
                _iter12.write((TProtocol)oprot);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetTaskDetail()) {
                optionals.set(0);
            }
            if (struct.isSetSubTaskModel()) {
                optionals.set(1);
            }
            if (struct.isSetTaskErrors()) {
                optionals.set(2);
            }
            if (struct.isSetJobs()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetTaskDetail()) {
                oprot.writeString(struct.taskDetail);
            }
            if (struct.isSetSubTaskModel()) {
                oprot.writeBinary(struct.subTaskModel);
            }
            if (struct.isSetTaskErrors()) {
                oprot.writeI32(struct.taskErrors.size());
                for (ErrorModel _iter13 : struct.taskErrors) {
                    _iter13.write((TProtocol)oprot);
                }
            }
            if (struct.isSetJobs()) {
                oprot.writeI32(struct.jobs.size());
                for (JobModel _iter14 : struct.jobs) {
                    _iter14.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, TaskModel struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.taskId = iprot.readString();
            struct.setTaskIdIsSet(true);
            struct.taskType = TaskTypes.findByValue(iprot.readI32());
            struct.setTaskTypeIsSet(true);
            struct.parentProcessId = iprot.readString();
            struct.setParentProcessIdIsSet(true);
            struct.creationTime = iprot.readI64();
            struct.setCreationTimeIsSet(true);
            struct.lastUpdateTime = iprot.readI64();
            struct.setLastUpdateTimeIsSet(true);
            TList _list15 = new TList(12, iprot.readI32());
            struct.taskStatuses = new ArrayList(_list15.size);
            for (int _i17 = 0; _i17 < _list15.size; ++_i17) {
                TaskStatus _elem16 = new TaskStatus();
                _elem16.read((TProtocol)iprot);
                struct.taskStatuses.add(_elem16);
            }
            struct.setTaskStatusesIsSet(true);
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.taskDetail = iprot.readString();
                struct.setTaskDetailIsSet(true);
            }
            if (incoming.get(1)) {
                struct.subTaskModel = iprot.readBinary();
                struct.setSubTaskModelIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list18 = new TList(12, iprot.readI32());
                struct.taskErrors = new ArrayList(_list18.size);
                for (int _i20 = 0; _i20 < _list18.size; ++_i20) {
                    ErrorModel _elem19 = new ErrorModel();
                    _elem19.read((TProtocol)iprot);
                    struct.taskErrors.add(_elem19);
                }
                struct.setTaskErrorsIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list21 = new TList(12, iprot.readI32());
                struct.jobs = new ArrayList(_list21.size);
                for (int _i23 = 0; _i23 < _list21.size; ++_i23) {
                    JobModel _elem22 = new JobModel();
                    _elem22.read((TProtocol)iprot);
                    struct.jobs.add(_elem22);
                }
                struct.setJobsIsSet(true);
            }
        }
    }

    private static class TaskModelTupleSchemeFactory
    implements SchemeFactory {
        private TaskModelTupleSchemeFactory() {
        }

        public TaskModelTupleScheme getScheme() {
            return new TaskModelTupleScheme();
        }
    }

    private static class TaskModelStandardScheme
    extends StandardScheme<TaskModel> {
        private TaskModelStandardScheme() {
        }

        public void read(TProtocol iprot, TaskModel struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.taskId = iprot.readString();
                            struct.setTaskIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.taskType = TaskTypes.findByValue(iprot.readI32());
                            struct.setTaskTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.parentProcessId = iprot.readString();
                            struct.setParentProcessIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.creationTime = iprot.readI64();
                            struct.setCreationTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.lastUpdateTime = iprot.readI64();
                            struct.setLastUpdateTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.taskStatuses = new ArrayList(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                TaskStatus _elem1 = new TaskStatus();
                                _elem1.read(iprot);
                                struct.taskStatuses.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setTaskStatusesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.taskDetail = iprot.readString();
                            struct.setTaskDetailIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.subTaskModel = iprot.readBinary();
                            struct.setSubTaskModelIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 15) {
                            TList _list3 = iprot.readListBegin();
                            struct.taskErrors = new ArrayList(_list3.size);
                            for (int _i5 = 0; _i5 < _list3.size; ++_i5) {
                                ErrorModel _elem4 = new ErrorModel();
                                _elem4.read(iprot);
                                struct.taskErrors.add(_elem4);
                            }
                            iprot.readListEnd();
                            struct.setTaskErrorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 15) {
                            TList _list6 = iprot.readListBegin();
                            struct.jobs = new ArrayList(_list6.size);
                            for (int _i8 = 0; _i8 < _list6.size; ++_i8) {
                                JobModel _elem7 = new JobModel();
                                _elem7.read(iprot);
                                struct.jobs.add(_elem7);
                            }
                            iprot.readListEnd();
                            struct.setJobsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TaskModel struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.taskId != null) {
                oprot.writeFieldBegin(TASK_ID_FIELD_DESC);
                oprot.writeString(struct.taskId);
                oprot.writeFieldEnd();
            }
            if (struct.taskType != null) {
                oprot.writeFieldBegin(TASK_TYPE_FIELD_DESC);
                oprot.writeI32(struct.taskType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.parentProcessId != null) {
                oprot.writeFieldBegin(PARENT_PROCESS_ID_FIELD_DESC);
                oprot.writeString(struct.parentProcessId);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(CREATION_TIME_FIELD_DESC);
            oprot.writeI64(struct.creationTime);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(LAST_UPDATE_TIME_FIELD_DESC);
            oprot.writeI64(struct.lastUpdateTime);
            oprot.writeFieldEnd();
            if (struct.taskStatuses != null) {
                oprot.writeFieldBegin(TASK_STATUSES_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.taskStatuses.size()));
                for (TaskStatus _iter9 : struct.taskStatuses) {
                    _iter9.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.taskDetail != null && struct.isSetTaskDetail()) {
                oprot.writeFieldBegin(TASK_DETAIL_FIELD_DESC);
                oprot.writeString(struct.taskDetail);
                oprot.writeFieldEnd();
            }
            if (struct.subTaskModel != null && struct.isSetSubTaskModel()) {
                oprot.writeFieldBegin(SUB_TASK_MODEL_FIELD_DESC);
                oprot.writeBinary(struct.subTaskModel);
                oprot.writeFieldEnd();
            }
            if (struct.taskErrors != null && struct.isSetTaskErrors()) {
                oprot.writeFieldBegin(TASK_ERRORS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.taskErrors.size()));
                for (ErrorModel _iter10 : struct.taskErrors) {
                    _iter10.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.jobs != null && struct.isSetJobs()) {
                oprot.writeFieldBegin(JOBS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.jobs.size()));
                for (JobModel _iter11 : struct.jobs) {
                    _iter11.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TaskModelStandardSchemeFactory
    implements SchemeFactory {
        private TaskModelStandardSchemeFactory() {
        }

        public TaskModelStandardScheme getScheme() {
            return new TaskModelStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TASK_ID(1, "taskId"),
        TASK_TYPE(2, "taskType"),
        PARENT_PROCESS_ID(3, "parentProcessId"),
        CREATION_TIME(4, "creationTime"),
        LAST_UPDATE_TIME(5, "lastUpdateTime"),
        TASK_STATUSES(6, "taskStatuses"),
        TASK_DETAIL(7, "taskDetail"),
        SUB_TASK_MODEL(8, "subTaskModel"),
        TASK_ERRORS(9, "taskErrors"),
        JOBS(10, "jobs");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TASK_ID;
                }
                case 2: {
                    return TASK_TYPE;
                }
                case 3: {
                    return PARENT_PROCESS_ID;
                }
                case 4: {
                    return CREATION_TIME;
                }
                case 5: {
                    return LAST_UPDATE_TIME;
                }
                case 6: {
                    return TASK_STATUSES;
                }
                case 7: {
                    return TASK_DETAIL;
                }
                case 8: {
                    return SUB_TASK_MODEL;
                }
                case 9: {
                    return TASK_ERRORS;
                }
                case 10: {
                    return JOBS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

