/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.messaging.event;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.model.messaging.event.JobIdentifier;
import org.apache.airavata.model.status.JobState;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class JobStatusChangeRequestEvent
implements TBase<JobStatusChangeRequestEvent, _Fields>,
Serializable,
Cloneable,
Comparable<JobStatusChangeRequestEvent> {
    private static final TStruct STRUCT_DESC = new TStruct("JobStatusChangeRequestEvent");
    private static final TField STATE_FIELD_DESC = new TField("state", 8, 1);
    private static final TField JOB_IDENTITY_FIELD_DESC = new TField("jobIdentity", 12, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private JobState state;
    private JobIdentifier jobIdentity;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public JobStatusChangeRequestEvent() {
    }

    public JobStatusChangeRequestEvent(JobState state, JobIdentifier jobIdentity) {
        this();
        this.state = state;
        this.jobIdentity = jobIdentity;
    }

    public JobStatusChangeRequestEvent(JobStatusChangeRequestEvent other) {
        if (other.isSetState()) {
            this.state = other.state;
        }
        if (other.isSetJobIdentity()) {
            this.jobIdentity = new JobIdentifier(other.jobIdentity);
        }
    }

    public JobStatusChangeRequestEvent deepCopy() {
        return new JobStatusChangeRequestEvent(this);
    }

    public void clear() {
        this.state = null;
        this.jobIdentity = null;
    }

    public JobState getState() {
        return this.state;
    }

    public void setState(JobState state) {
        this.state = state;
    }

    public void unsetState() {
        this.state = null;
    }

    public boolean isSetState() {
        return this.state != null;
    }

    public void setStateIsSet(boolean value) {
        if (!value) {
            this.state = null;
        }
    }

    public JobIdentifier getJobIdentity() {
        return this.jobIdentity;
    }

    public void setJobIdentity(JobIdentifier jobIdentity) {
        this.jobIdentity = jobIdentity;
    }

    public void unsetJobIdentity() {
        this.jobIdentity = null;
    }

    public boolean isSetJobIdentity() {
        return this.jobIdentity != null;
    }

    public void setJobIdentityIsSet(boolean value) {
        if (!value) {
            this.jobIdentity = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case STATE: {
                if (value == null) {
                    this.unsetState();
                    break;
                }
                this.setState((JobState)((Object)value));
                break;
            }
            case JOB_IDENTITY: {
                if (value == null) {
                    this.unsetJobIdentity();
                    break;
                }
                this.setJobIdentity((JobIdentifier)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case STATE: {
                return this.getState();
            }
            case JOB_IDENTITY: {
                return this.getJobIdentity();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case STATE: {
                return this.isSetState();
            }
            case JOB_IDENTITY: {
                return this.isSetJobIdentity();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof JobStatusChangeRequestEvent) {
            return this.equals((JobStatusChangeRequestEvent)that);
        }
        return false;
    }

    public boolean equals(JobStatusChangeRequestEvent that) {
        if (that == null) {
            return false;
        }
        boolean this_present_state = this.isSetState();
        boolean that_present_state = that.isSetState();
        if (this_present_state || that_present_state) {
            if (!this_present_state || !that_present_state) {
                return false;
            }
            if (!this.state.equals((Object)that.state)) {
                return false;
            }
        }
        boolean this_present_jobIdentity = this.isSetJobIdentity();
        boolean that_present_jobIdentity = that.isSetJobIdentity();
        if (this_present_jobIdentity || that_present_jobIdentity) {
            if (!this_present_jobIdentity || !that_present_jobIdentity) {
                return false;
            }
            if (!this.jobIdentity.equals(that.jobIdentity)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_state = this.isSetState();
        list.add(Boolean.valueOf(present_state));
        if (present_state) {
            list.add(Integer.valueOf(this.state.getValue()));
        }
        boolean present_jobIdentity = this.isSetJobIdentity();
        list.add(Boolean.valueOf(present_jobIdentity));
        if (present_jobIdentity) {
            list.add(this.jobIdentity);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(JobStatusChangeRequestEvent other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetState()).compareTo(other.isSetState());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetState() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.state), (Comparable)((Object)other.state))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetJobIdentity()).compareTo(other.isSetJobIdentity());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJobIdentity() && (lastComparison = TBaseHelper.compareTo((Comparable)this.jobIdentity, (Comparable)other.jobIdentity)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JobStatusChangeRequestEvent(");
        boolean first = true;
        sb.append("state:");
        if (this.state == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.state);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("jobIdentity:");
        if (this.jobIdentity == null) {
            sb.append("null");
        } else {
            sb.append(this.jobIdentity);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetState()) {
            throw new TProtocolException("Required field 'state' is unset! Struct:" + this.toString());
        }
        if (!this.isSetJobIdentity()) {
            throw new TProtocolException("Required field 'jobIdentity' is unset! Struct:" + this.toString());
        }
        if (this.jobIdentity != null) {
            this.jobIdentity.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new JobStatusChangeRequestEventStandardSchemeFactory());
        schemes.put(TupleScheme.class, new JobStatusChangeRequestEventTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.STATE, new FieldMetaData("state", 1, (FieldValueMetaData)new EnumMetaData(16, JobState.class)));
        tmpMap.put(_Fields.JOB_IDENTITY, new FieldMetaData("jobIdentity", 1, (FieldValueMetaData)new StructMetaData(12, JobIdentifier.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(JobStatusChangeRequestEvent.class, metaDataMap);
    }

    private static class JobStatusChangeRequestEventTupleScheme
    extends TupleScheme<JobStatusChangeRequestEvent> {
        private JobStatusChangeRequestEventTupleScheme() {
        }

        public void write(TProtocol prot, JobStatusChangeRequestEvent struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.state.getValue());
            struct.jobIdentity.write((TProtocol)oprot);
        }

        public void read(TProtocol prot, JobStatusChangeRequestEvent struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.state = JobState.findByValue(iprot.readI32());
            struct.setStateIsSet(true);
            struct.jobIdentity = new JobIdentifier();
            struct.jobIdentity.read((TProtocol)iprot);
            struct.setJobIdentityIsSet(true);
        }
    }

    private static class JobStatusChangeRequestEventTupleSchemeFactory
    implements SchemeFactory {
        private JobStatusChangeRequestEventTupleSchemeFactory() {
        }

        public JobStatusChangeRequestEventTupleScheme getScheme() {
            return new JobStatusChangeRequestEventTupleScheme();
        }
    }

    private static class JobStatusChangeRequestEventStandardScheme
    extends StandardScheme<JobStatusChangeRequestEvent> {
        private JobStatusChangeRequestEventStandardScheme() {
        }

        public void read(TProtocol iprot, JobStatusChangeRequestEvent struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.state = JobState.findByValue(iprot.readI32());
                            struct.setStateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.jobIdentity = new JobIdentifier();
                            struct.jobIdentity.read(iprot);
                            struct.setJobIdentityIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, JobStatusChangeRequestEvent struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.state != null) {
                oprot.writeFieldBegin(STATE_FIELD_DESC);
                oprot.writeI32(struct.state.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.jobIdentity != null) {
                oprot.writeFieldBegin(JOB_IDENTITY_FIELD_DESC);
                struct.jobIdentity.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class JobStatusChangeRequestEventStandardSchemeFactory
    implements SchemeFactory {
        private JobStatusChangeRequestEventStandardSchemeFactory() {
        }

        public JobStatusChangeRequestEventStandardScheme getScheme() {
            return new JobStatusChangeRequestEventStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        STATE(1, "state"),
        JOB_IDENTITY(2, "jobIdentity");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return STATE;
                }
                case 2: {
                    return JOB_IDENTITY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

