/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<CreateAutoScalingGroupRequest>, CreateAutoScalingGroupRequest> {
    public Request<CreateAutoScalingGroupRequest> marshall(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {
        if (createAutoScalingGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAutoScalingGroupRequest, "AmazonAutoScaling");
        request.addParameter("Action", "CreateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        if (createAutoScalingGroupRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)createAutoScalingGroupRequest.getAutoScalingGroupName()));
        }
        if (createAutoScalingGroupRequest.getLaunchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString((String)createAutoScalingGroupRequest.getLaunchConfigurationName()));
        }
        if (createAutoScalingGroupRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createAutoScalingGroupRequest.getInstanceId()));
        }
        if (createAutoScalingGroupRequest.getMinSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.getMinSize()));
        }
        if (createAutoScalingGroupRequest.getMaxSize() != null) {
            request.addParameter("MaxSize", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.getMaxSize()));
        }
        if (createAutoScalingGroupRequest.getDesiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.getDesiredCapacity()));
        }
        if (createAutoScalingGroupRequest.getDefaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.getDefaultCooldown()));
        }
        List<String> availabilityZonesList = createAutoScalingGroupRequest.getAvailabilityZones();
        int availabilityZonesListIndex = 1;
        for (String availabilityZonesListValue : availabilityZonesList) {
            if (availabilityZonesListValue != null) {
                request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
            }
            ++availabilityZonesListIndex;
        }
        List<String> loadBalancerNamesList = createAutoScalingGroupRequest.getLoadBalancerNames();
        int loadBalancerNamesListIndex = 1;
        for (String loadBalancerNamesListValue : loadBalancerNamesList) {
            if (loadBalancerNamesListValue != null) {
                request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringUtils.fromString((String)loadBalancerNamesListValue));
            }
            ++loadBalancerNamesListIndex;
        }
        if (createAutoScalingGroupRequest.getHealthCheckType() != null) {
            request.addParameter("HealthCheckType", StringUtils.fromString((String)createAutoScalingGroupRequest.getHealthCheckType()));
        }
        if (createAutoScalingGroupRequest.getHealthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.getHealthCheckGracePeriod()));
        }
        if (createAutoScalingGroupRequest.getPlacementGroup() != null) {
            request.addParameter("PlacementGroup", StringUtils.fromString((String)createAutoScalingGroupRequest.getPlacementGroup()));
        }
        if (createAutoScalingGroupRequest.getVPCZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier", StringUtils.fromString((String)createAutoScalingGroupRequest.getVPCZoneIdentifier()));
        }
        List<String> terminationPoliciesList = createAutoScalingGroupRequest.getTerminationPolicies();
        int terminationPoliciesListIndex = 1;
        for (String terminationPoliciesListValue : terminationPoliciesList) {
            if (terminationPoliciesListValue != null) {
                request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex, StringUtils.fromString((String)terminationPoliciesListValue));
            }
            ++terminationPoliciesListIndex;
        }
        List<Tag> tagsList = createAutoScalingGroupRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getResourceId() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceId", StringUtils.fromString((String)tagMember.getResourceId()));
                }
                if (tagMember.getResourceType() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceType", StringUtils.fromString((String)tagMember.getResourceType()));
                }
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagMember.getValue()));
                }
                if (tagMember.isPropagateAtLaunch() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".PropagateAtLaunch", StringUtils.fromBoolean((Boolean)tagMember.isPropagateAtLaunch()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

