/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.provider.simple;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.globus.gsi.provider.simple.SimpleMemoryCertStoreParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMemoryCertStore
extends CertStoreSpi {
    private List<X509CRL> crlStore;
    private List<X509Certificate> certStore;

    public SimpleMemoryCertStore(CertStoreParameters params) throws InvalidAlgorithmParameterException {
        super(params);
        if (params == null) {
            throw new InvalidAlgorithmParameterException();
        }
        this.crlStore = new LinkedList<X509CRL>();
        this.certStore = new LinkedList<X509Certificate>();
        if (!(params instanceof SimpleMemoryCertStoreParams)) {
            throw new IllegalArgumentException("wrong parameter type");
        }
        SimpleMemoryCertStoreParams pms = (SimpleMemoryCertStoreParams)params;
        X509Certificate[] certs = pms.getCerts();
        X509CRL[] crls = pms.getCrls();
        if (certs != null) {
            for (X509Extension x509Extension : certs) {
                if (x509Extension == null) continue;
                this.certStore.add((X509Certificate)x509Extension);
            }
        }
        if (crls != null) {
            for (X509Extension x509Extension : crls) {
                if (x509Extension == null) continue;
                this.crlStore.add((X509CRL)x509Extension);
            }
        }
    }

    @Override
    public Collection<? extends CRL> engineGetCRLs(CRLSelector selector) throws CertStoreException {
        LinkedList<X509CRL> l = new LinkedList<X509CRL>();
        for (X509CRL crl : this.crlStore) {
            if (!selector.match(crl)) continue;
            l.add(crl);
        }
        return l;
    }

    @Override
    public Collection<? extends Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        LinkedList<X509Certificate> l = new LinkedList<X509Certificate>();
        X509CertSelector select = (X509CertSelector)selector;
        for (X509Certificate cert : this.certStore) {
            if (!selector.match(cert)) continue;
            l.add(cert);
        }
        return l;
    }
}

