/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.bc;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.globus.gsi.X509Extension;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.util.I18n;

public class BouncyCastleX509Extension
extends X509Extension {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.errors", BouncyCastleX509Extension.class.getClassLoader());

    public BouncyCastleX509Extension(String oid) {
        this(oid, false, (ASN1Encodable)null);
    }

    public BouncyCastleX509Extension(String oid, ASN1Encodable value) {
        this(oid, false, value);
    }

    public BouncyCastleX509Extension(String oid, boolean critical, ASN1Encodable value) {
        super(oid, critical, null);
        this.setValue(value);
    }

    protected void setValue(ASN1Encodable value) {
        if (value == null) {
            return;
        }
        try {
            this.setValue(BouncyCastleUtil.toByteArray(value.toASN1Primitive()));
        }
        catch (IOException e) {
            throw new RuntimeException(i18n.getMessage("byteArrayErr") + e.getMessage());
        }
    }
}

