/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.common;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.entitlement.common.InMemoryPersistenceManager;
import org.wso2.carbon.identity.entitlement.common.PolicyEditorException;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;

public class RegistryPersistenceManager
extends InMemoryPersistenceManager {
    @Override
    public void persistConfig(String policyEditorType, String xmlConfig) throws PolicyEditorException {
        super.persistConfig(policyEditorType, xmlConfig);
        Registry registry = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
        try {
            Resource resource = registry.newResource();
            resource.setContent((Object)xmlConfig);
            String path = null;
            path = "BASIC".equals(policyEditorType) ? "repository/identity/entitlement/policyEditor/config/basic/config.xml" : ("STANDARD".equals(policyEditorType) ? "repository/identity/entitlement/policyEditor/config/standard/config.xml" : ("RBAC".equals(policyEditorType) ? "repository/identity/entitlement/policyEditor/config/rbac/config.xml" : ("SET".equals(policyEditorType) ? "repository/identity/entitlement/policyEditor/config/set/config.xml" : "repository/identity/entitlement/policyEditor/config/basic/config.xml")));
            registry.put(path, resource);
        }
        catch (RegistryException e) {
            throw new PolicyEditorException("Error while persisting policy editor config");
        }
    }

    @Override
    public Map<String, String> getConfig() {
        Map<String, String> config = super.getConfig();
        if (config == null || config.size() == 0) {
            Resource resource;
            config = new HashMap<String, String>();
            Registry registry = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
            String configString = null;
            try {
                resource = registry.get("repository/identity/entitlement/policyEditor/config/basic/config.xml");
                if (resource != null && resource.getContent() != null) {
                    configString = new String((byte[])resource.getContent(), Charset.forName("UTF-8"));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (configString == null) {
                configString = this.getDefaultConfig();
            }
            config.put("BASIC", configString);
            configString = null;
            try {
                resource = registry.get("repository/identity/entitlement/policyEditor/config/standard/config.xml");
                if (resource != null && resource.getContent() != null) {
                    configString = new String((byte[])resource.getContent(), Charset.forName("UTF-8"));
                    config.put("STANDARD", configString);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (configString == null) {
                configString = this.getDefaultConfig();
            }
            config.put("STANDARD", configString);
            configString = null;
            try {
                resource = registry.get("repository/identity/entitlement/policyEditor/config/rbac/config.xml");
                if (resource != null && resource.getContent() != null) {
                    configString = new String((byte[])resource.getContent(), Charset.forName("UTF-8"));
                    config.put("RBAC", configString);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (configString == null) {
                configString = this.getSimpleConfig();
            }
            config.put("RBAC", configString);
            configString = null;
            try {
                resource = registry.get("repository/identity/entitlement/policyEditor/config/set/config.xml");
                if (resource != null && resource.getContent() != null) {
                    configString = new String((byte[])resource.getContent(), Charset.forName("UTF-8"));
                    config.put("SET", configString);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (configString == null) {
                configString = this.getDefaultSetConfig();
            }
            config.put("SET", configString);
        }
        return config;
    }
}

