/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class Error
extends SystemFunctionCall
implements Callable {
    public int computeSpecialProperties() {
        return super.computeSpecialProperties() & 0xFFBFFFFF;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public boolean isVacuousExpression() {
        return true;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        int len = this.argument.length;
        switch (len) {
            case 0: {
                return this.error(context, null, null, null);
            }
            case 1: {
                QNameValue arg0 = (QNameValue)this.argument[0].evaluateItem(context);
                if (arg0 == null) {
                    arg0 = new QNameValue("err", "http://www.w3.org/2005/xqt-errors", "XPTY0004");
                }
                return this.error(context, arg0, null, null);
            }
            case 2: {
                return this.error(context, (QNameValue)this.argument[0].evaluateItem(context), (StringValue)this.argument[1].evaluateItem(context), null);
            }
            case 3: {
                return this.error(context, (QNameValue)this.argument[0].evaluateItem(context), (StringValue)this.argument[1].evaluateItem(context), this.argument[2].iterate(context));
            }
        }
        return null;
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        this.evaluateItem(context);
    }

    public Item error(XPathContext context, QNameValue errorCode, StringValue desc, SequenceIterator errObject) throws XPathException {
        QNameValue qname = null;
        if (this.argument.length > 0) {
            qname = errorCode;
        }
        if (qname == null) {
            qname = new QNameValue("err", "http://www.w3.org/2005/xqt-errors", this.argument.length == 1 ? "FOTY0004" : "FOER0000", BuiltInAtomicType.QNAME, false);
        }
        String description = this.argument.length > 1 ? (desc == null ? "" : desc.getStringValue()) : "Error signalled by application call on error()";
        XPathException e = new XPathException(description);
        e.setErrorCodeQName(qname.getStructuredQName());
        e.setXPathContext(context);
        e.setLocator(this);
        if (this.argument.length > 2 && errObject != null) {
            AxisIterator iter;
            NodeInfo errorElement;
            Object root;
            GroundedValue errorObject = SequenceExtent.makeSequenceExtent(errObject);
            if (errorObject instanceof ZeroOrOne && (root = ((ZeroOrOne)errorObject).head()) instanceof NodeInfo && ((NodeInfo)root).getNodeKind() == 9 && (errorElement = (iter = ((NodeInfo)root).iterateAxis((byte)3, new NameTest(1, "", "error", context.getConfiguration().getNamePool()))).next()) != null) {
                String module = errorElement.getAttributeValue("", "module");
                String line = errorElement.getAttributeValue("", "line");
                String column = errorElement.getAttributeValue("", "column");
                ExpressionLocation locator = new ExpressionLocation();
                locator.setSystemId(module);
                if (line != null) {
                    locator.setLineNumber(Integer.parseInt(line));
                }
                if (column != null) {
                    locator.setColumnNumber(Integer.parseInt(column));
                }
                e.setLocator(locator);
            }
            e.setErrorObject(errorObject);
        }
        throw e;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        int len = arguments.length;
        switch (len) {
            case 0: {
                return this.error(context, null, null, null);
            }
            case 1: {
                QNameValue arg0 = (QNameValue)arguments[0].head();
                if (arg0 == null) {
                    arg0 = new QNameValue("err", "http://www.w3.org/2005/xqt-errors", "XPTY0004");
                }
                return this.error(context, arg0, null, null);
            }
            case 2: {
                return this.error(context, (QNameValue)arguments[0].head(), (StringValue)arguments[1].head(), null);
            }
            case 3: {
                return this.error(context, (QNameValue)arguments[0].head(), (StringValue)arguments[1].head(), arguments[2].iterate());
            }
        }
        return null;
    }
}

