/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.tx;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.queue.QueueOperation;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public class TxnPrepareBackupOperation
extends QueueOperation
implements BackupOperation {
    long itemId;
    boolean pollOperation;

    public TxnPrepareBackupOperation() {
    }

    public TxnPrepareBackupOperation(String name, long itemId, boolean pollOperation) {
        super(name);
        this.itemId = itemId;
        this.pollOperation = pollOperation;
    }

    @Override
    public void run() throws Exception {
        if (this.pollOperation) {
            this.response = this.getOrCreateContainer().txnPollBackupReserve(this.itemId);
        } else {
            this.getOrCreateContainer().txnOfferBackupReserve(this.itemId);
            this.response = true;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.pollOperation);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.pollOperation = in.readBoolean();
    }

    @Override
    public int getId() {
        return 27;
    }
}

