/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue;

import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.queue.QueueContainer;
import com.hazelcast.queue.QueueDataSerializerHook;
import com.hazelcast.queue.QueueEvent;
import com.hazelcast.queue.QueueEventFilter;
import com.hazelcast.queue.QueueService;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import java.io.IOException;
import java.util.Collection;

public abstract class QueueOperation
extends Operation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    protected String name;
    protected long timeoutMillis;
    protected transient Object response;
    private transient QueueContainer container;

    protected QueueOperation() {
    }

    protected QueueOperation(String name) {
        this.name = name;
    }

    protected QueueOperation(String name, long timeoutMillis) {
        this.name = name;
        this.timeoutMillis = timeoutMillis;
    }

    protected final QueueContainer getOrCreateContainer() {
        if (this.container == null) {
            QueueService queueService = (QueueService)this.getService();
            try {
                this.container = queueService.getOrCreateContainer(this.name, this instanceof BackupOperation);
            }
            catch (Exception e) {
                throw new RetryableHazelcastException(e);
            }
        }
        return this.container;
    }

    @Override
    public final Object getResponse() {
        return this.response;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:queueService";
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public final boolean returnsResponse() {
        return true;
    }

    public final long getWaitTimeoutMillis() {
        return this.timeoutMillis;
    }

    public boolean hasListener() {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(this.getServiceName(), this.name);
        return registrations.size() > 0;
    }

    public void publishEvent(ItemEventType eventType, Data data) {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(this.getServiceName(), this.name);
        for (EventRegistration registration : registrations) {
            QueueEventFilter filter = (QueueEventFilter)registration.getFilter();
            QueueEvent event = new QueueEvent(this.name, filter.isIncludeValue() ? data : null, eventType, this.getNodeEngine().getThisAddress());
            eventService.publishEvent(this.getServiceName(), registration, (Object)event, this.name.hashCode());
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.timeoutMillis);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.timeoutMillis = in.readLong();
    }

    protected QueueService getQueueService() {
        return (QueueService)this.getService();
    }

    @Override
    public int getFactoryId() {
        return QueueDataSerializerHook.F_ID;
    }
}

