/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ByteArraySerializer;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerAdapter;
import java.io.IOException;

final class ByteArraySerializerAdapter
implements SerializerAdapter {
    private final ByteArraySerializer serializer;

    public ByteArraySerializerAdapter(ByteArraySerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void write(ObjectDataOutput out, Object object) throws IOException {
        byte[] bytes = this.serializer.write(object);
        out.writeInt(bytes != null ? bytes.length : 0);
        out.write(bytes);
    }

    @Override
    public Object read(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        if (len > 0) {
            byte[] bytes = new byte[len];
            in.readFully(bytes);
            return this.serializer.read(bytes);
        }
        return null;
    }

    @Override
    public byte[] write(Object object) throws IOException {
        return this.serializer.write(object);
    }

    @Override
    public Object read(Data data) throws IOException {
        return this.serializer.read(data.buffer);
    }

    @Override
    public int getTypeId() {
        return this.serializer.getTypeId();
    }

    @Override
    public void destroy() {
        this.serializer.destroy();
    }

    @Override
    public Serializer getImpl() {
        return this.serializer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SerializerAdapter{");
        sb.append("serializer=").append(this.serializer);
        sb.append('}');
        return sb.toString();
    }
}

