/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor;

import com.hazelcast.executor.CallableTaskOperation;
import com.hazelcast.executor.MemberCallableTaskOperation;
import com.hazelcast.executor.RunnableAdapter;
import com.hazelcast.executor.client.IsShutdownRequest;
import com.hazelcast.executor.client.LocalTargetCallableRequest;
import com.hazelcast.executor.client.ShutdownRequest;
import com.hazelcast.executor.client.TargetCallableRequest;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializerHook;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;

public class ExecutorDataSerializerHook
implements DataSerializerHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.executor", -13);
    static final int CALLABLE_TASK = 0;
    static final int MEMBER_CALLABLE_TASK = 1;
    static final int RUNNABLE_ADAPTER = 2;
    public static final int TARGET_CALLABLE_REQUEST = 6;
    public static final int LOCAL_TARGET_CALLABLE_REQUEST = 7;
    public static final int SHUTDOWN_REQUEST = 8;
    public static final int IS_SHUTDOWN_REQUEST = 9;

    @Override
    public int getFactoryId() {
        return F_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return new DataSerializableFactory(){

            @Override
            public IdentifiedDataSerializable create(int typeId) {
                switch (typeId) {
                    case 0: {
                        return new CallableTaskOperation();
                    }
                    case 1: {
                        return new MemberCallableTaskOperation();
                    }
                    case 2: {
                        return new RunnableAdapter();
                    }
                    case 6: {
                        return new TargetCallableRequest();
                    }
                    case 7: {
                        return new LocalTargetCallableRequest();
                    }
                    case 8: {
                        return new ShutdownRequest();
                    }
                    case 9: {
                        return new IsShutdownRequest();
                    }
                }
                return null;
            }
        };
    }
}

