/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.idgen;

import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IdGenerator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class IdGeneratorProxy
implements IdGenerator {
    private static final int BLOCK_SIZE = 10000;
    final String name;
    final IAtomicLong atomicLong;
    AtomicInteger residue;
    AtomicLong local;

    public IdGeneratorProxy(IAtomicLong atomicLong, String name) {
        this.name = name;
        this.atomicLong = atomicLong;
        this.residue = new AtomicInteger(10000);
        this.local = new AtomicLong(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(long id) {
        if (id <= 0L) {
            return false;
        }
        long step = id / 10000L;
        IdGeneratorProxy idGeneratorProxy = this;
        synchronized (idGeneratorProxy) {
            boolean init = this.atomicLong.compareAndSet(0L, step + 1L);
            if (init) {
                this.local.set(step);
                this.residue.set((int)(id % 10000L) + 1);
            }
            return init;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long newId() {
        int value = this.residue.getAndIncrement();
        if (value >= 10000) {
            IdGeneratorProxy idGeneratorProxy = this;
            synchronized (idGeneratorProxy) {
                value = this.residue.get();
                if (value >= 10000) {
                    this.local.set(this.atomicLong.getAndIncrement());
                    this.residue.set(0);
                }
                return this.newId();
            }
        }
        return this.local.get() * 10000L + (long)value;
    }

    @Override
    public Object getId() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:idGeneratorService";
    }

    @Override
    public void destroy() {
        this.atomicLong.destroy();
        this.residue = null;
        this.local = null;
    }
}

