/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.RemoveOperation;
import com.hazelcast.collection.operations.client.CollectionKeyBasedRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class RemoveRequest
extends CollectionKeyBasedRequest
implements InitializingObjectRequest {
    Data value;
    int threadId;

    public RemoveRequest() {
    }

    public RemoveRequest(CollectionProxyId proxyId, Data key, Data value, int threadId) {
        super(proxyId, key);
        this.value = value;
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        return new RemoveOperation(this.proxyId, this.key, this.threadId, this.value);
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("t", this.threadId);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.value.writeData(out);
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.threadId = reader.readInt("t");
        ObjectDataInput in = reader.getRawDataInput();
        this.value = new Data();
        this.value.readData(in);
        super.readPortable(reader);
    }
}

