/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.secret;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.secret.MultiSecretCallback;
import org.wso2.securevault.secret.SecretCallback;
import org.wso2.securevault.secret.SecretCallbackHandler;
import org.wso2.securevault.secret.SingleSecretCallback;

public abstract class AbstractSecretCallbackHandler
implements SecretCallbackHandler {
    protected Log log = LogFactory.getLog(this.getClass());

    protected AbstractSecretCallbackHandler() {
    }

    public void handle(SecretCallback[] secretCallbacks) {
        if (secretCallbacks == null || secretCallbacks.length == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Provided  SecretCallbacks are empty or null.");
            }
            return;
        }
        for (SecretCallback secretCallback : secretCallbacks) {
            if (secretCallback instanceof SingleSecretCallback) {
                this.handleSingleSecretCallback((SingleSecretCallback)secretCallback);
                continue;
            }
            if (!(secretCallback instanceof MultiSecretCallback)) continue;
            this.handleMultiSecretCallback((MultiSecretCallback)secretCallback);
        }
    }

    private void handleMultiSecretCallback(MultiSecretCallback multiSecretCallback) {
        Iterator<SecretCallback> callbackIterator = multiSecretCallback.getSecretCallbacks();
        while (callbackIterator.hasNext()) {
            SecretCallback callback = callbackIterator.next();
            if (callback instanceof SingleSecretCallback) {
                this.handleSingleSecretCallback((SingleSecretCallback)callback);
                continue;
            }
            if (!(callback instanceof MultiSecretCallback)) continue;
            this.handleMultiSecretCallback((MultiSecretCallback)callback);
        }
    }

    protected abstract void handleSingleSecretCallback(SingleSecretCallback var1);
}

