/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest;
import com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RemoveTagsRequestMarshaller
implements Marshaller<Request<RemoveTagsRequest>, RemoveTagsRequest> {
    public Request<RemoveTagsRequest> marshall(RemoveTagsRequest removeTagsRequest) {
        if (removeTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeTagsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "RemoveTags");
        request.addParameter("Version", "2012-06-01");
        List<String> loadBalancerNamesList = removeTagsRequest.getLoadBalancerNames();
        int loadBalancerNamesListIndex = 1;
        for (String loadBalancerNamesListValue : loadBalancerNamesList) {
            if (loadBalancerNamesListValue != null) {
                request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringUtils.fromString((String)loadBalancerNamesListValue));
            }
            ++loadBalancerNamesListIndex;
        }
        List<TagKeyOnly> tagsList = removeTagsRequest.getTags();
        int tagsListIndex = 1;
        for (TagKeyOnly tagsListValue : tagsList) {
            TagKeyOnly tagKeyOnlyMember = tagsListValue;
            if (tagKeyOnlyMember != null && tagKeyOnlyMember.getKey() != null) {
                request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagKeyOnlyMember.getKey()));
            }
            ++tagsListIndex;
        }
        return request;
    }
}

