/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.direct;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ServerSocketFactory;
import net.schmizz.concurrent.Event;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.SocketStreamCopyMonitor;
import net.schmizz.sshj.connection.channel.direct.AbstractDirectChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPortForwarder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Connection conn;
    private final ServerSocket ss;
    private final String host;
    private final int port;

    public LocalPortForwarder(Connection conn, SocketAddress listeningAddr, String host, int port) throws IOException {
        this(ServerSocketFactory.getDefault(), conn, listeningAddr, host, port);
    }

    public LocalPortForwarder(ServerSocketFactory ssf, Connection conn, SocketAddress listeningAddr, String host, int port) throws IOException {
        this.conn = conn;
        this.host = host;
        this.port = port;
        this.ss = ssf.createServerSocket();
        this.ss.setReceiveBufferSize(conn.getMaxPacketSize());
        this.ss.bind(listeningAddr);
    }

    public SocketAddress getListeningAddress() {
        return this.ss.getLocalSocketAddress();
    }

    public void listen() throws IOException {
        this.log.info("Listening on {}", (Object)this.ss.getLocalSocketAddress());
        while (!Thread.currentThread().isInterrupted()) {
            Socket sock = this.ss.accept();
            this.log.info("Got connection from {}", (Object)sock.getRemoteSocketAddress());
            DirectTCPIPChannel chan = new DirectTCPIPChannel(this.conn, sock);
            chan.open();
            chan.start();
        }
        this.log.info("Interrupted!");
    }

    private class DirectTCPIPChannel
    extends AbstractDirectChannel {
        private final Socket sock;

        private DirectTCPIPChannel(Connection conn, Socket sock) {
            super(conn, "direct-tcpip");
            this.sock = sock;
        }

        private void start() throws IOException {
            this.sock.setSendBufferSize(this.getLocalMaxPacketSize());
            this.sock.setReceiveBufferSize(this.getRemoteMaxPacketSize());
            Event<IOException> soc2chan = new StreamCopier(this.sock.getInputStream(), this.getOutputStream()).bufSize(this.getRemoteMaxPacketSize()).spawnDaemon("soc2chan");
            Event<IOException> chan2soc = new StreamCopier(this.getInputStream(), this.sock.getOutputStream()).bufSize(this.getLocalMaxPacketSize()).spawnDaemon("chan2soc");
            SocketStreamCopyMonitor.monitor(5, TimeUnit.SECONDS, soc2chan, chan2soc, this, this.sock);
        }

        @Override
        protected SSHPacket buildOpenReq() {
            return (SSHPacket)((SSHPacket)((SSHPacket)((SSHPacket)super.buildOpenReq().putString(LocalPortForwarder.this.host)).putUInt32(LocalPortForwarder.this.port)).putString(LocalPortForwarder.this.ss.getInetAddress().getHostAddress())).putUInt32(LocalPortForwarder.this.ss.getLocalPort());
        }
    }
}

