/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateConfigurationTemplateRequestMarshaller
implements Marshaller<Request<CreateConfigurationTemplateRequest>, CreateConfigurationTemplateRequest> {
    public Request<CreateConfigurationTemplateRequest> marshall(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) {
        SourceConfiguration sourceConfigurationSourceConfiguration;
        if (createConfigurationTemplateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createConfigurationTemplateRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateConfigurationTemplate");
        request.addParameter("Version", "2010-12-01");
        if (createConfigurationTemplateRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)createConfigurationTemplateRequest.getApplicationName()));
        }
        if (createConfigurationTemplateRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)createConfigurationTemplateRequest.getTemplateName()));
        }
        if (createConfigurationTemplateRequest.getSolutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString((String)createConfigurationTemplateRequest.getSolutionStackName()));
        }
        if ((sourceConfigurationSourceConfiguration = createConfigurationTemplateRequest.getSourceConfiguration()) != null) {
            if (sourceConfigurationSourceConfiguration.getApplicationName() != null) {
                request.addParameter("SourceConfiguration.ApplicationName", StringUtils.fromString((String)sourceConfigurationSourceConfiguration.getApplicationName()));
            }
            if (sourceConfigurationSourceConfiguration.getTemplateName() != null) {
                request.addParameter("SourceConfiguration.TemplateName", StringUtils.fromString((String)sourceConfigurationSourceConfiguration.getTemplateName()));
            }
        }
        if (createConfigurationTemplateRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)createConfigurationTemplateRequest.getEnvironmentId()));
        }
        if (createConfigurationTemplateRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createConfigurationTemplateRequest.getDescription()));
        }
        List<ConfigurationOptionSetting> optionSettingsList = createConfigurationTemplateRequest.getOptionSettings();
        int optionSettingsListIndex = 1;
        for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
            ConfigurationOptionSetting configurationOptionSettingMember = optionSettingsListValue;
            if (configurationOptionSettingMember != null) {
                if (configurationOptionSettingMember.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)configurationOptionSettingMember.getNamespace()));
                }
                if (configurationOptionSettingMember.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)configurationOptionSettingMember.getOptionName()));
                }
                if (configurationOptionSettingMember.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)configurationOptionSettingMember.getValue()));
                }
            }
            ++optionSettingsListIndex;
        }
        return request;
    }
}

