/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage;

import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.storage.FSInitializer;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.tree.ConfigurationNode;

public abstract class FSProvider<T extends FileStore>
extends TypedProvider<T> {
    protected static final String PATH_KEY = "path";
    protected static final String INDEX_KEY = "indexPath";
    protected static final String DATA_KEY = "dataPath";
    protected MapConverter converter;

    public FSProvider(ConfigurationNode config, String type, String target, MapConverter converter) {
        super(config, type, target);
        this.converter = converter;
    }

    protected FSProvider(String type, String target, MapConverter converter) {
        super(type, target);
        this.converter = converter;
    }

    public Object componentFound(CfgEvent configurationEvent) {
        if (this.checkEvent(configurationEvent)) {
            return this.get();
        }
        return null;
    }

    public T get() {
        T fs = null;
        String path = this.getTypeAttribute(PATH_KEY);
        String dataPath = null;
        String indexPath = null;
        if (path != null) {
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (this.getTarget() != null) {
                path = path + this.getTarget();
            }
            File dp = new File(path, DATA_KEY);
            File ip = new File(path, INDEX_KEY);
            try {
                if (!dp.exists()) {
                    dp.mkdirs();
                }
                if (!ip.exists()) {
                    ip.mkdirs();
                }
                dataPath = dp.getCanonicalPath();
                indexPath = ip.getCanonicalPath();
            }
            catch (IOException e) {}
        } else {
            dataPath = this.getTypeAttribute(DATA_KEY);
            if (dataPath == null) {
                throw new MyConfigurationException("Error: file store has no dataPath configured");
            }
            indexPath = this.getTypeAttribute(INDEX_KEY);
            if (indexPath == null) {
                throw new MyConfigurationException("Error: file store has no indexPath configured");
            }
        }
        File indexDirectory = new File(indexPath);
        File storeDirectory = new File(dataPath);
        fs = this.produce(storeDirectory, indexDirectory);
        FSInitializer initializable = new FSInitializer(storeDirectory, indexDirectory);
        if (!initializable.isCreated()) {
            initializable.createNew();
        }
        return fs;
    }

    protected abstract T produce(File var1, File var2);
}

