/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.log;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.GenericConfigurable;
import org.apache.openjpa.lib.log.AbstractLog;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;
import org.apache.openjpa.lib.util.Files;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;

public class LogFactoryImpl
implements LogFactory,
GenericConfigurable,
Configurable {
    private static Localizer _loc = Localizer.forPackage(LogFactoryImpl.class);
    private static Localizer _locEn = Localizer.forPackage(LogFactoryImpl.class, Locale.ENGLISH);
    public static final String TRACE_STR = _locEn.get("log-trace").getMessage();
    public static final String INFO_STR = _locEn.get("log-info").getMessage();
    public static final String WARN_STR = _locEn.get("log-warn").getMessage();
    public static final String ERROR_STR = _locEn.get("log-error").getMessage();
    public static final String FATAL_STR = _locEn.get("log-fatal").getMessage();
    public static final String STDOUT = "stdout";
    public static final String STDERR = "stderr";
    private static final String NEWLINE = J2DoPrivHelper.getLineSeparator();
    protected final long initializationMillis;
    private Map<String, LogImpl> _logs = new ConcurrentHashMap<String, LogImpl>();
    private short _defaultLogLevel = (short)3;
    private Map<String, Short> _configuredLevels = new HashMap<String, Short>();
    private PrintStream _out = System.err;
    private String _diagContext = null;
    private boolean _diagContextComputed = false;
    private Configuration _conf;

    public LogFactoryImpl() {
        this.initializationMillis = System.currentTimeMillis();
    }

    @Override
    public Log getLog(String channel) {
        LogImpl l = this._logs.get(channel);
        if (l == null) {
            l = this.newLogImpl();
            l.setChannel(channel);
            Short lvl = this._configuredLevels.get(LogFactoryImpl.shorten(channel));
            l.setLevel(lvl == null ? this._defaultLogLevel : lvl);
            this._logs.put(channel, l);
        }
        return l;
    }

    protected LogImpl newLogImpl() {
        return new LogImpl();
    }

    public void setDefaultLevel(String level) {
        this._defaultLogLevel = LogFactoryImpl.getLevel(level);
    }

    public short getDefaultLevel() {
        return this._defaultLogLevel;
    }

    public void setDefaultLevel(short level) {
        this._defaultLogLevel = level;
    }

    public void setDiagnosticContext(String val) {
        this._diagContext = val;
    }

    public String getDiagnosticContext() {
        if (!this._diagContextComputed) {
            if (this._diagContext == null && this._conf != null) {
                this._diagContext = this._conf.getId();
            }
            if ("".equals(this._diagContext)) {
                this._diagContext = null;
            }
            this._diagContextComputed = true;
        }
        return this._diagContext;
    }

    public void setFile(String file) {
        if (STDOUT.equals(file)) {
            this._out = System.out;
        } else if (STDERR.equals(file)) {
            this._out = System.err;
        } else {
            File f = Files.getFile(file, null);
            try {
                this._out = new PrintStream(AccessController.doPrivileged(J2DoPrivHelper.newFileOutputStreamAction(AccessController.doPrivileged(J2DoPrivHelper.getCanonicalPathAction(f)), true)));
            }
            catch (PrivilegedActionException pae) {
                throw new IllegalArgumentException(_loc.get("log-bad-file", file) + " " + pae.getException());
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(_loc.get("log-bad-file", file) + " " + ioe.toString());
            }
        }
    }

    public PrintStream getStream() {
        return this._out;
    }

    public void setStream(PrintStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream == null");
        }
        this._out = stream;
    }

    public static String getLevelName(short level) {
        switch (level) {
            case 1: {
                return TRACE_STR;
            }
            case 3: {
                return INFO_STR;
            }
            case 4: {
                return WARN_STR;
            }
            case 5: {
                return ERROR_STR;
            }
            case 6: {
                return FATAL_STR;
            }
        }
        return _locEn.get("log-unknown").getMessage();
    }

    public static short getLevel(String str) {
        int val;
        int n = TRACE_STR.equals(str = str.toUpperCase(Locale.ENGLISH).trim()) ? 1 : (INFO_STR.equals(str) ? 3 : (WARN_STR.equals(str) ? 4 : (ERROR_STR.equals(str) ? 5 : (val = FATAL_STR.equals(str) ? 6 : -1))));
        if (val == -1) {
            throw new IllegalArgumentException(_loc.get("log-bad-constant", str).getMessage());
        }
        return (short)val;
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this._conf = conf;
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
    }

    @Override
    public void setInto(Options opts) {
        if (!opts.isEmpty()) {
            for (Map.Entry<Object, Object> e : opts.entrySet()) {
                this._configuredLevels.put(LogFactoryImpl.shorten((String)e.getKey()), LogFactoryImpl.getLevel((String)e.getValue()));
            }
            opts.clear();
        }
    }

    private static String shorten(String channel) {
        return channel.substring(channel.lastIndexOf(46) + 1);
    }

    public class LogImpl
    extends AbstractLog {
        private short _level = (short)3;
        private String _channel;

        @Override
        protected boolean isEnabled(short level) {
            return level >= this._level;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void log(short level, String message, Throwable t) {
            String msg = this.formatMessage(level, message, t);
            PrintStream printStream = LogFactoryImpl.this._out;
            synchronized (printStream) {
                LogFactoryImpl.this._out.print(msg);
            }
        }

        protected String formatMessage(short level, String message, Throwable t) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getOffset());
            buf.append("  ");
            if (LogFactoryImpl.this.getDiagnosticContext() != null) {
                buf.append(LogFactoryImpl.this.getDiagnosticContext()).append("  ");
            }
            buf.append(LogFactoryImpl.getLevelName(level));
            if (level == 3 || level == 4) {
                buf.append(" ");
            }
            buf.append("  [");
            buf.append(Thread.currentThread().getName());
            buf.append("] ");
            buf.append(this._channel);
            buf.append(" - ");
            buf.append(message);
            buf.append(NEWLINE);
            if (t != null) {
                StringWriter swriter = new StringWriter();
                PrintWriter pwriter = new PrintWriter(swriter);
                t.printStackTrace(pwriter);
                pwriter.flush();
                buf.append(swriter.toString());
            }
            return buf.toString();
        }

        private long getOffset() {
            return System.currentTimeMillis() - LogFactoryImpl.this.initializationMillis;
        }

        public void setChannel(String val) {
            this._channel = val;
        }

        public String getChannel() {
            return this._channel;
        }

        public void setLevel(short val) {
            this._level = val;
        }

        public short getLevel() {
            return this._level;
        }
    }
}

